/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.util;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentServiceImpl;
import org.eclipse.datatools.enablement.ibm.IBMPluginActivator;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.accesscontrol.Privilege;
import org.eclipse.datatools.modelbase.sql.accesscontrol.RoleAuthorization;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;

public class AccessControlUtilities {
    public static final String AUTH_ID_TYPE_PUBLIC_TEXT = "(PUBLIC)";
    public static final String AUTH_ID_PUBLIC_TEXT = "PUBLIC";
    protected static boolean asClauseRequested = false;
    protected static boolean genSysGrantedRequested = false;
    protected String product;
    protected String version;

    public static boolean isSystemGrantedPrivilege(Privilege privilege) {
        String grantorName;
        AuthorizationIdentifier grantor;
        String detail;
        EAnnotation eAnnotation = privilege.getEAnnotation("PRIVILEGE_PROPERTY");
        if (eAnnotation != null && (detail = (String)eAnnotation.getDetails().get((Object)"PRIVILEGE_SYSTEM_GRANT")) != null) {
            return Boolean.valueOf(detail);
        }
        ContainmentService contServ = IBMPluginActivator.getInstance().getContainmentService();
        SQLObject db = privilege.getObject();
        while (!(db instanceof Database) && contServ.getContainer((EObject)db) != null) {
            db = contServ.getContainer((EObject)db);
        }
        return db instanceof Database && ((Database)db).getVendor().equalsIgnoreCase("DB2 UDB") && (grantor = privilege.getGrantor()) != null && (grantorName = grantor.getName()) != null && grantorName.equalsIgnoreCase("SYSIBM");
    }

    public static boolean isDDLSuppressable(Privilege privilege) {
        return AccessControlUtilities.isSystemGrantedPrivilege(privilege) && !AccessControlUtilities.isGenSysGrantedRequested();
    }

    public boolean isEditable(Privilege priv) {
        return !AccessControlUtilities.isSystemGrantedPrivilege(priv);
    }

    public boolean isEditable(EClass eClazz, String action) {
        return true;
    }

    public boolean isRoleOptionGrant() {
        return true;
    }

    public boolean isGrantableEditable(Privilege priv) {
        return this.supportsGrantable(priv) && this.isEditable(priv) && this.authIdSupportsGrantable(priv.getGrantee());
    }

    public boolean supportsGrantable(RoleAuthorization roleAuth) {
        return true;
    }

    public boolean canRoleAdminRole() {
        return true;
    }

    public boolean authIdSupportsGrantable(AuthorizationIdentifier authId) {
        return true;
    }

    public boolean authIdSupportsGrantable(EClass eClazz) {
        return true;
    }

    public boolean supportsGrantable(Privilege privilege) {
        return true;
    }

    public boolean supportsGrantable(EClass eClazz, String action) {
        return true;
    }

    public static boolean isAsClauseRequested() {
        return asClauseRequested;
    }

    public static void setAsClauseRequested(boolean useAsClause) {
        asClauseRequested = useAsClause;
    }

    public static boolean isGenSysGrantedRequested() {
        return genSysGrantedRequested;
    }

    public static void setGenSysGrantedRequested(boolean genSysGranted) {
        genSysGrantedRequested = genSysGranted;
    }

    public ArrayList getPublicAuthIds() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(AUTH_ID_PUBLIC_TEXT);
        return list;
    }

    public boolean isPublicAuthId(String id) {
        if (id == null) {
            return false;
        }
        ArrayList list = this.getPublicAuthIds();
        return list.contains(id);
    }

    public EClass getPublicEClass() {
        return SQLAccessControlPackage.eINSTANCE.getUser();
    }

    public Object[] getChildren(Database database, SQLObject parentObject, EClass eClass) {
        return null;
    }

    public boolean isValidGranteePrivilegedObjectPair(EClass granteeClass, EClass privilegedObjectClass) {
        return true;
    }

    public static boolean match(Privilege e1, Privilege e2) {
        SQLObject o2;
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.isGrantable() != e2.isGrantable()) {
            return false;
        }
        String a1 = e1.getAction();
        if (a1 == null || !a1.equals(e2.getAction())) {
            return false;
        }
        SQLObject o1 = e1.getObject();
        if (!AccessControlUtilities.matchSQLObjects(o1, o2 = e2.getObject())) {
            return false;
        }
        AuthorizationIdentifier g1 = e1.getGrantee();
        AuthorizationIdentifier g2 = e2.getGrantee();
        if (g1 == null || g2 == null) {
            return false;
        }
        if (g1.eClass() != g2.eClass()) {
            return false;
        }
        String n1 = g1.getName();
        return n1 != null && n1.equals(g2.getName());
    }

    private static boolean matchSQLObjects(SQLObject o1, SQLObject o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.eClass() != o2.eClass()) {
            return false;
        }
        String n1 = o1.getName();
        if (n1 == null || !n1.equals(o2.getName())) {
            return false;
        }
        ENamedElement c1 = AccessControlUtilities.getContainer(o1);
        ENamedElement c2 = AccessControlUtilities.getContainer(o2);
        if (c1 != null && c2 != null) {
            return c1.getName() != null && c1.getName().equals(c2.getName());
        }
        return (c1 != null || c2 == null) && (c1 == null || c2 != null);
    }

    private static ENamedElement getContainer(SQLObject o) {
        EObject c1 = ContainmentServiceImpl.INSTANCE.getContainer((EObject)o);
        if (c1 != null) {
            if (SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(c1.eClass())) {
                return (Schema)c1;
            }
            if (EcorePackage.eINSTANCE.getENamedElement().isSuperTypeOf(c1.eClass()) && "ZSeriesDatabaseInstance".equals(c1.eClass().getName())) {
                return (ENamedElement)c1;
            }
            EObject c2 = ContainmentServiceImpl.INSTANCE.getContainer(c1);
            if (c2 != null && SQLSchemaPackage.eINSTANCE.getSchema().isSuperTypeOf(c2.eClass())) {
                return (Schema)c2;
            }
        }
        return null;
    }

    public String getSQLObjectTreeText(Object object) {
        return ((SQLObject)object).getName();
    }

    public boolean isGrantableSupportedForPublic() {
        return true;
    }

    public boolean isValidSupertype(EClass superClass, EClass objectClass) {
        return superClass.isSuperTypeOf(objectClass);
    }
}

