/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.utils;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.Workbench;

public class EditorUtil {
    private static final String PROPERTY_QUALIFIER = "org.eclipse.jst.pagedesigner";
    private static final String PERSIST_PROPERTY_NAME_DESIGNER_MODE = "DesignMode";
    private static final QualifiedName PERSIST_PROPERTY_KEY_DESIGNER_MODE = new QualifiedName("org.eclipse.jst.pagedesigner", "DesignMode");

    public static String getEditorInputDesignModeProperty(IEditorInput editorInput) {
        IResource res;
        String dmProperty = null;
        if (editorInput != null && (res = ResourceUtil.getResource((IEditorInput)editorInput)) != null) {
            try {
                dmProperty = res.getPersistentProperty(PERSIST_PROPERTY_KEY_DESIGNER_MODE);
            }
            catch (CoreException coreException) {}
        }
        return dmProperty;
    }

    public static void setEditorInputDesignModeProperty(IEditorInput editorInput, String mode) {
        IResource res;
        if (editorInput != null && (res = ResourceUtil.getResource((IEditorInput)editorInput)) != null) {
            try {
                res.setPersistentProperty(PERSIST_PROPERTY_KEY_DESIGNER_MODE, mode);
            }
            catch (CoreException coreException) {}
        }
    }

    public static void refreshAllWPEDesignViewers() {
        IWorkbenchPage page;
        IWorkbenchWindow window = Workbench.getInstance().getActiveWorkbenchWindow();
        if (window != null && (page = window.getActivePage()) != null) {
            IEditorReference[] editorRefs;
            IEditorReference[] iEditorReferenceArray = editorRefs = page.getEditorReferences();
            int n = editorRefs.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorRef = iEditorReferenceArray[n2];
                IEditorPart editorPart = editorRef.getEditor(false);
                if (editorPart instanceof HTMLEditor) {
                    ((HTMLEditor)editorPart).refreshDesignViewer();
                }
                ++n2;
            }
        }
    }
}

