/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.html.core.internal.format.HTMLFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;

public class EmbeddedCSSFormatter
extends HTMLFormatter {
    protected EmbeddedCSSFormatter() {
    }

    @Override
    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        IDOMText text = (IDOMText)node;
        String source = this.getCSSContent(node);
        if (source == null) {
            source = text.getSource();
        }
        int offset = text.getStartOffset();
        int length = text.getEndOffset() - offset;
        this.replaceSource(text.getModel(), offset, length, source);
        this.setWidth(contraints, source);
    }

    private String getCSSContent(IDOMNode text) {
        ICSSModel model = this.getCSSModel(text);
        if (model == null) {
            return null;
        }
        ICSSDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)document;
        CSSSourceFormatter formatter = (CSSSourceFormatter)notifier.getAdapterFor(CSSSourceFormatter.class);
        if (formatter == null) {
            formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter(notifier);
        }
        if (formatter == null) {
            return null;
        }
        StringBuffer buffer = formatter.format((ICSSNode)document);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    private ICSSModel getCSSModel(IDOMNode text) {
        if (text == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)text.getParentNode();
        if (notifier == null) {
            return null;
        }
        INodeAdapter adapter = notifier.getAdapterFor(IStyleSheetAdapter.class);
        if (adapter == null) {
            return null;
        }
        if (!(adapter instanceof IStyleSheetAdapter)) {
            return null;
        }
        IStyleSheetAdapter styleAdapter = (IStyleSheetAdapter)adapter;
        return styleAdapter.getModel();
    }
}

