/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl;

import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Service;
import javax.wsdl.Types;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.WSITag;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcessVisitor;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.wsdl.WSDLValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.ErrorList;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversal;
import org.eclipse.wst.wsi.internal.core.wsdl.traversal.WSDLTraversalContext;
import org.eclipse.wst.wsi.internal.core.xml.XMLUtils;
import org.w3c.dom.Element;

public class WSI2099
extends AssertionProcessVisitor
implements WSITag {
    private final WSDLValidatorImpl validator;
    private ErrorList errors = new ErrorList();
    private boolean containsClaims = false;

    public WSI2099(WSDLValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    @Override
    public void visit(Element el, Object parent, WSDLTraversalContext ctx) {
        if (this.containsConformanceClaim(el)) {
            this.containsClaims = true;
            if (parent instanceof BindingFault) {
                this.errors.add(WSDL_FAULT, ((BindingFault)parent).getName());
            } else if (parent instanceof BindingInput) {
                this.errors.add(WSDL_INPUT, ((BindingInput)parent).getName());
            } else if (parent instanceof BindingOperation) {
                this.errors.add(WSDL_OPERATION, ((BindingOperation)parent).getName());
            } else if (parent instanceof BindingOutput) {
                this.errors.add(WSDL_OUTPUT, ((BindingOutput)parent).getName());
            } else if (parent instanceof Definition) {
                this.errors.add(WSDL_DEFINITIONS, ((Definition)parent).getQName());
            } else if (parent instanceof Service) {
                this.errors.add(WSDL_SERVICE, ((Service)parent).getQName());
            } else if (parent instanceof Fault) {
                this.errors.add(WSDL_FAULT, ((Fault)parent).getName());
            } else if (parent instanceof Output) {
                this.errors.add(WSDL_INPUT, ((Output)parent).getName());
            } else if (parent instanceof Import) {
                this.errors.add(WSDL_IMPORT, ((Import)parent).getNamespaceURI());
            } else if (parent instanceof Input) {
                this.errors.add(WSDL_INPUT, ((Input)parent).getName());
            } else if (parent instanceof Part) {
                this.errors.add(WSDL_PART, ((Part)parent).getName());
            } else if (parent instanceof Types) {
                this.errors.add(WSDL_TYPES);
            }
        }
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "failed";
        WSDLTraversal traversal = new WSDLTraversal();
        traversal.setVisitor(this);
        traversal.visitElement(true);
        traversal.ignoreReferences();
        traversal.ignoreImport();
        traversal.traverse((Definition)entryContext.getEntry().getEntryDetail());
        if (!this.errors.isEmpty()) {
            this.failureDetail = this.validator.createFailureDetail(this.errors.toString(), entryContext);
            this.result = "failed";
        } else {
            this.result = !this.containsClaims ? "notApplicable" : "passed";
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetail);
    }

    private boolean containsConformanceClaim(Element el) {
        if (el == null) {
            return false;
        }
        return (el = XMLUtils.findChildElement(el, WSI_CLAIM)) != null;
    }
}

