/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.util.manifest;

import java.util.Hashtable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.DriverExtensionManifest;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.PropertyProviderManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;

public class ExtensionExplorer {
    private static ExtensionExplorer sm_instance = null;
    private static final String DTP_ODA_BRIDGE_EXT_POINT = "org.eclipse.datatools.connectivity.oda.consumer.driverBridge";
    private Hashtable m_bridgeManifests;
    private Hashtable m_propProviderManifests;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExtensionExplorer getInstance() {
        if (sm_instance != null) return sm_instance;
        Class<ExtensionExplorer> clazz = ExtensionExplorer.class;
        synchronized (ExtensionExplorer.class) {
            if (sm_instance != null) return sm_instance;
            sm_instance = new ExtensionExplorer();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sm_instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseInstance() {
        Class<ExtensionExplorer> clazz = ExtensionExplorer.class;
        synchronized (ExtensionExplorer.class) {
            sm_instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private ExtensionExplorer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        ExtensionExplorer extensionExplorer = this;
        synchronized (extensionExplorer) {
            this.m_bridgeManifests = null;
            this.m_propProviderManifests = null;
        }
    }

    public DriverExtensionManifest getDriverExtensionManifest(String driverType) throws OdaException {
        DriverExtensionManifest manifest = this.getDriverExtensionManifest(driverType, DTP_ODA_BRIDGE_EXT_POINT);
        return manifest;
    }

    private DriverExtensionManifest getDriverExtensionManifest(String driverType, String extensionPoint) throws OdaException {
        if (driverType == null || driverType.length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(driverType));
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(extensionPoint));
        }
        DriverExtensionManifest aManifest = (DriverExtensionManifest)this.getBridgeManifests().get(driverType);
        if (aManifest != null) {
            return aManifest;
        }
        IExtension extension = this.findExtensionWithAttribute(driverType, "driverType", "bridge", extensionPoint);
        if (extension == null) {
            return null;
        }
        aManifest = new DriverExtensionManifest(extension);
        this.getBridgeManifests().put(driverType, aManifest);
        return aManifest;
    }

    private IExtension findExtensionWithAttribute(String attributeValue, String attributeName, String elementName, String extensionPoint) throws OdaException {
        IExtension[] extensions = ManifestExplorer.getExtensions((String)extensionPoint);
        int length = extensions == null ? 0 : extensions.length;
        int i = 0;
        while (i < length) {
            String value;
            IExtension extension = extensions[i];
            IConfigurationElement foundElement = ExtensionExplorer.getNamedElement(extension, elementName, attributeName);
            if (foundElement != null && (value = foundElement.getAttribute(attributeName)) != null && value.equalsIgnoreCase(attributeValue)) {
                return extension;
            }
            ++i;
        }
        return null;
    }

    public PropertyProviderManifest getPropertyProviderManifest(String applicationId) throws OdaException {
        PropertyProviderManifest manifest = this.getPropertyProviderManifest(applicationId, "org.eclipse.datatools.connectivity.oda.consumer.propertyProvider");
        return manifest;
    }

    private PropertyProviderManifest getPropertyProviderManifest(String applicationId, String extensionPoint) throws OdaException {
        if (applicationId == null || applicationId.length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(applicationId));
        }
        if (extensionPoint == null || extensionPoint.length() == 0) {
            throw new OdaException((Throwable)new IllegalArgumentException(extensionPoint));
        }
        PropertyProviderManifest aManifest = (PropertyProviderManifest)this.getPropProviderManifests().get(applicationId);
        if (aManifest != null) {
            return aManifest;
        }
        IExtension extension = this.findExtensionWithAttribute(applicationId, "consumerApplicationId", "dataSourcePropertyService", extensionPoint);
        if (extension == null) {
            return null;
        }
        aManifest = new PropertyProviderManifest(extension);
        this.getPropProviderManifests().put(applicationId, aManifest);
        return aManifest;
    }

    static IConfigurationElement getNamedElement(IExtension extension, String elementName, String requiredAttributeName) {
        IConfigurationElement[] namedElements = null;
        try {
            namedElements = ManifestUtil.getNamedElements((IExtension)extension, (String)elementName, (String)requiredAttributeName);
        }
        catch (OdaException odaException) {}
        if (namedElements == null || namedElements.length == 0) {
            return null;
        }
        return namedElements[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getBridgeManifests() {
        if (this.m_bridgeManifests == null) {
            ExtensionExplorer extensionExplorer = this;
            synchronized (extensionExplorer) {
                if (this.m_bridgeManifests == null) {
                    this.m_bridgeManifests = new Hashtable();
                }
            }
        }
        return this.m_bridgeManifests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable getPropProviderManifests() {
        if (this.m_propProviderManifests == null) {
            ExtensionExplorer extensionExplorer = this;
            synchronized (extensionExplorer) {
                if (this.m_propProviderManifests == null) {
                    this.m_propProviderManifests = new Hashtable();
                }
            }
        }
        return this.m_propProviderManifests;
    }
}

