/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.internal.core.DocumentContextFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.Member;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.project.JsWebNature;
import org.eclipse.wst.jsdt.web.core.javascript.CompilationUnitHelper;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslation;
import org.eclipse.wst.jsdt.web.core.javascript.IJsTranslator;
import org.eclipse.wst.jsdt.web.core.javascript.JsNameManglerUtil;
import org.eclipse.wst.jsdt.web.core.javascript.JsProblemRequestor;
import org.eclipse.wst.jsdt.web.core.javascript.JsTranslator;
import org.eclipse.wst.jsdt.web.core.javascript.WebRootFinder;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class JsTranslation
implements IJsTranslation {
    private static final boolean DEBUG;
    private IJavaScriptUnit fCompilationUnit = null;
    private DocumentContextFragmentRoot fDocumentScope;
    private IJavaScriptProject fJavaProject = null;
    private byte[] fLock = null;
    private IProgressMonitor fProgressMonitor = null;
    protected IStructuredDocument fHtmlDocument;
    protected String fModelBaseLocation;
    protected IJsTranslator fTranslator;
    private String mangledName;
    protected boolean listenForChanges;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jstranslation");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public JsTranslation() {
    }

    public IJsTranslator getTranslator() {
        if (this.fTranslator != null) {
            return this.fTranslator;
        }
        this.fTranslator = new JsTranslator(this.fHtmlDocument, this.fModelBaseLocation, this.listenForChanges);
        return this.fTranslator;
    }

    protected JsTranslation(IStructuredDocument htmlDocument, IJavaScriptProject javaProj, boolean listenForChanges) {
        this.fLock = new byte[0];
        this.fJavaProject = javaProj;
        this.fHtmlDocument = htmlDocument;
        this.setBaseLocation();
        this.mangledName = this.createMangledName();
        this.listenForChanges = listenForChanges;
    }

    @Override
    public IJsTranslation getInstance(IStructuredDocument htmlDocument, IJavaScriptProject javaProj, boolean listenForChanges) {
        return new JsTranslation(htmlDocument, javaProj, listenForChanges);
    }

    @Override
    public IJavaScriptProject getJavaProject() {
        return this.fJavaProject;
    }

    private IPackageFragmentRoot getDocScope(boolean reset) {
        if (this.fDocumentScope == null) {
            this.fDocumentScope = new DocumentContextFragmentRoot(this.fJavaProject, this.getFile(), WebRootFinder.getWebContentFolder(this.fJavaProject.getProject()), WebRootFinder.getServerContextRoot(this.fJavaProject.getProject()), JsWebNature.VIRTUAL_SCOPE_ENTRY);
            this.fDocumentScope.setIncludedFiles(this.getTranslator().getRawImports());
            return this.fDocumentScope;
        }
        if (reset) {
            this.fDocumentScope.setIncludedFiles(this.getTranslator().getRawImports());
        }
        return this.fDocumentScope;
    }

    private void setBaseLocation() {
        IDOMModel xmlModel = null;
        try {
            IModelManager modelManager = StructuredModelManager.getModelManager();
            xmlModel = (IDOMModel)modelManager.getExistingModelForRead((IDocument)this.fHtmlDocument);
            if (xmlModel == null) {
                xmlModel = (IDOMModel)modelManager.getModelForRead(this.fHtmlDocument);
            }
            if (xmlModel != null) {
                this.fModelBaseLocation = xmlModel.getBaseLocation();
            }
        }
        finally {
            if (xmlModel != null) {
                xmlModel.releaseFromRead();
            }
        }
    }

    public IFile getFile() {
        return FileBuffers.getWorkspaceFileAtLocation((IPath)new Path(this.fModelBaseLocation));
    }

    @Override
    public IDocument getHtmlDocument() {
        return this.fHtmlDocument;
    }

    @Override
    public int getMissingTagStart() {
        return this.getTranslator().getMissingEndTagRegionStart();
    }

    @Override
    public int getJavaScriptOffset(int indexOf) {
        return ((JsTranslator)this.getTranslator()).getJavaScriptOffset(indexOf);
    }

    @Override
    public int getWebPageOffset(int indexOf) {
        return ((JsTranslator)this.getTranslator()).getWebOffset(indexOf);
    }

    private String getWebRoot() {
        return WebRootFinder.getWebContentFolder(this.fJavaProject.getProject()).toString();
    }

    public String getDirectoryUnderRoot() {
        String webRoot = this.getWebRoot();
        IPath projectWebRootPath = this.getJavaProject().getPath().append(webRoot);
        IPath filePath = new Path(this.fModelBaseLocation).removeLastSegments(1);
        return filePath.removeFirstSegments(projectWebRootPath.matchingFirstSegments(filePath)).toString();
    }

    private IJavaScriptUnit createCompilationUnit() throws JavaScriptModelException {
        IBuffer buffer;
        IPackageFragmentRoot root = this.getDocScope(true);
        IJavaScriptUnit cu = root.getPackageFragment("").getJavaScriptUnit(String.valueOf(this.getMangledName()) + ".js").getWorkingCopy(this.getWorkingCopyOwner(), this.getProgressMonitor());
        try {
            buffer = cu.getBuffer();
        }
        catch (JavaScriptModelException e) {
            e.printStackTrace();
            buffer = null;
        }
        if (buffer != null) {
            this.getTranslator().setBuffer(buffer);
        }
        return cu;
    }

    @Override
    public String fixupMangledName(String displayString) {
        if (displayString == null) {
            return null;
        }
        return displayString.replaceAll(String.valueOf(this.getMangledName()) + ".js", this.getHtmlPageName());
    }

    @Override
    public IJavaScriptElement[] getAllElementsInJsRange(int javaPositionStart, int javaPositionEnd) {
        IJavaScriptElement[] EMTPY_RESULT_SET;
        IJavaScriptElement[] result = EMTPY_RESULT_SET = new IJavaScriptElement[0];
        IJavaScriptElement[] allChildren = null;
        try {
            allChildren = this.getCompilationUnit().getChildren();
        }
        catch (JavaScriptModelException javaScriptModelException) {}
        Vector<IJavaScriptElement> validChildren = new Vector<IJavaScriptElement>();
        int i = 0;
        while (i < allChildren.length) {
            ISourceRange range = this.getJSSourceRangeOf(allChildren[i]);
            if (javaPositionStart <= range.getOffset() && range.getLength() + range.getOffset() <= javaPositionEnd) {
                validChildren.add(allChildren[i]);
            } else if (allChildren[i].getElementType() == 7) {
                validChildren.add(allChildren[i]);
            }
            ++i;
        }
        if (validChildren.size() > 0) {
            result = validChildren.toArray(new IJavaScriptElement[0]);
        }
        if (result == null || result.length == 0) {
            return EMTPY_RESULT_SET;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJavaScriptUnit getCompilationUnit() {
        if (!this.getJavaProject().exists()) {
            return null;
        }
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            block9: {
                try {
                    if (this.fCompilationUnit == null) {
                        this.fCompilationUnit = this.createCompilationUnit();
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return this.fCompilationUnit;
                    }
                }
                catch (JavaScriptModelException jme) {
                    if (!DEBUG) break block9;
                    Logger.logException("error creating JSP working copy... ", jme);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.getDocScope(true);
            try {
                this.fCompilationUnit = this.fCompilationUnit.getWorkingCopy(this.getWorkingCopyOwner(), this.getProgressMonitor());
            }
            catch (JavaScriptModelException ex) {
                ex.printStackTrace();
            }
            return this.fCompilationUnit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public IJavaScriptElement[] getElementsFromJsRange(int javaPositionStart, int javaPositionEnd) {
        IJavaScriptElement[] EMTPY_RESULT_SET;
        IJavaScriptElement[] result = EMTPY_RESULT_SET = new IJavaScriptElement[0];
        try {
            IJavaScriptUnit cu = this.getCompilationUnit();
            if (cu != null) {
                byte[] byArray = this.fLock;
                // MONITORENTER : this.fLock
                int cuDocLength = cu.getBuffer().getLength();
                int javaLength = javaPositionEnd - javaPositionStart;
                if (cuDocLength > 0 && javaPositionStart >= 0 && javaLength >= 0 && javaPositionEnd <= cuDocLength) {
                    result = cu.codeSelect(javaPositionStart, javaLength, this.getWorkingCopyOwner());
                }
                // MONITOREXIT : byArray
            }
            if (result == null) return EMTPY_RESULT_SET;
            if (result.length != 0) return result;
            return EMTPY_RESULT_SET;
        }
        catch (JavaScriptModelException x) {
            Logger.logException(x);
        }
        return result;
    }

    public IJavaScriptElement[] getElementsFromWebRange(int webPositionStart, int webPositionEnd) {
        int javaScriptPositionStart = this.getJavaScriptOffset(webPositionStart);
        int javaScriptPositionEnd = this.getJavaScriptOffset(webPositionEnd);
        if (javaScriptPositionStart < 0 || javaScriptPositionEnd < 0) {
            return new IJavaScriptElement[0];
        }
        return this.getElementsFromJsRange(javaScriptPositionStart, javaScriptPositionEnd);
    }

    private String getHtmlPageName() {
        Path path = new Path(this.fModelBaseLocation);
        return path.lastSegment();
    }

    @Override
    public String getHtmlText() {
        return this.fHtmlDocument.get();
    }

    @Override
    public String getJavaPath() {
        IPath rootPath = new Path(this.fModelBaseLocation).removeLastSegments(1);
        String cuPath = rootPath.append("/" + this.getMangledName() + ".js").toString();
        return cuPath;
    }

    @Override
    public IJavaScriptElement getJsElementAtOffset(int jsOffset) {
        IJavaScriptElement elements;
        block2: {
            elements = null;
            try {
                elements = this.getCompilationUnit().getElementAt(jsOffset);
            }
            catch (JavaScriptModelException e) {
                if (!DEBUG) break block2;
                Logger.logException("error retrieving java elemtnt from compilation unit... ", e);
            }
        }
        return elements;
    }

    private ISourceRange getJSSourceRangeOf(IJavaScriptElement element) {
        ISourceRange range = null;
        if (element instanceof Member) {
            try {
                range = ((Member)element).getNameRange();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        } else if (element instanceof SourceRefElement) {
            try {
                range = ((SourceRefElement)element).getSourceRange();
            }
            catch (JavaScriptModelException e) {
                e.printStackTrace();
            }
        }
        return range;
    }

    @Override
    public String getJsText() {
        return this.getTranslator().getJsText();
    }

    @Override
    public Position[] getScriptPositions() {
        return this.getTranslator().getHtmlLocations();
    }

    @Override
    public void insertInFirstScriptRegion(String text) {
        Position[] pos = this.getScriptPositions();
        int scriptStartOffset = 0;
        if (pos != null && pos.length > 0) {
            scriptStartOffset = pos[0].getOffset();
        }
        String insertText = String.valueOf(scriptStartOffset == 0 ? "" : "\n") + text;
        this.insertScript(scriptStartOffset, insertText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertScript(int offset, String text) {
        IDOMModel xmlModel = null;
        Position[] inHtml = this.getScriptPositions();
        boolean isInsideExistingScriptRegion = false;
        int i = 0;
        while (i < inHtml.length) {
            if (inHtml[i].overlapsWith(offset, 1)) {
                isInsideExistingScriptRegion = true;
            }
            ++i;
        }
        String insertText = null;
        insertText = isInsideExistingScriptRegion ? text : (offset != 0 ? "\n" : "<script type=\"text/javascript\">\n" + text + "\n</script>\n");
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            try {
                xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getExistingModelForEdit((IDocument)this.fHtmlDocument);
                if (xmlModel == null) {
                    xmlModel = (IDOMModel)StructuredModelManager.getModelManager().getModelForEdit(this.fHtmlDocument);
                }
                if (xmlModel != null) {
                    xmlModel.aboutToChangeModel();
                    xmlModel.getDocument().getStructuredDocument().replaceText((Object)this, offset, 0, insertText);
                    xmlModel.changedModel();
                    try {
                        xmlModel.save();
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (CoreException coreException) {}
                }
            }
            finally {
                if (xmlModel != null) {
                    xmlModel.releaseFromEdit();
                }
            }
            // ** MonitorExit[var7_8] (shouldn't be in output)
            return;
        }
    }

    public String getMangledName() {
        return this.mangledName;
    }

    private String createMangledName() {
        return JsNameManglerUtil.mangle(this.fModelBaseLocation);
    }

    private JsProblemRequestor getProblemRequestor() {
        return CompilationUnitHelper.getInstance().getProblemRequestor();
    }

    @Override
    public List getProblems() {
        List problemList = this.getProblemRequestor().getCollectedProblems();
        this.getProblemRequestor().endReporting();
        IProblem[] problems = null;
        problems = problemList == null ? new IProblem[]{} : problemList.toArray(new IProblem[problemList.size()]);
        IJsTranslator translator = this.getTranslator();
        if (translator instanceof JsTranslator && problems.length > 0) {
            Region[] generatedRanges = ((JsTranslator)translator).getGeneratedRanges();
            int i = 0;
            while (i < problems.length) {
                int j = 0;
                while (j < generatedRanges.length) {
                    if (problems[i].getSourceStart() >= generatedRanges[j].getOffset() && problems[i].getSourceEnd() <= generatedRanges[j].getOffset() + generatedRanges[j].getLength()) {
                        problemList.remove(problems[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return problemList;
    }

    private IProgressMonitor getProgressMonitor() {
        if (this.fProgressMonitor == null) {
            this.fProgressMonitor = new NullProgressMonitor();
        }
        return this.fProgressMonitor;
    }

    public WorkingCopyOwner getWorkingCopyOwner() {
        return CompilationUnitHelper.getInstance().getWorkingCopyOwner();
    }

    @Override
    public boolean ifOffsetInImportNode(int offset) {
        Position[] importRanges = this.getTranslator().getImportHtmlRanges();
        int i = 0;
        while (i < importRanges.length) {
            if (importRanges[i].includes(offset)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reconcileCompilationUnit() {
        IJavaScriptUnit cu = this.getCompilationUnit();
        if (this.fCompilationUnit == null) {
            return;
        }
        if (cu != null) {
            try {
                byte[] byArray = this.fLock;
                synchronized (this.fLock) {
                    WorkingCopyOwner workingCopyOwner = this.getWorkingCopyOwner();
                    JsProblemRequestor problemRequestor = (JsProblemRequestor)workingCopyOwner.getProblemRequestor(cu.getWorkingCopy(this.getProgressMonitor()));
                    if (problemRequestor != null && problemRequestor.getCollectedProblems() != null) {
                        problemRequestor.getCollectedProblems().clear();
                    }
                    cu.reconcile(0, true, true, this.getWorkingCopyOwner(), this.getProgressMonitor());
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                }
            }
            catch (JavaScriptModelException e) {
                Logger.logException(e);
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        if (this.getTranslator() != null) {
            this.getTranslator().release();
        }
        byte[] byArray = this.fLock;
        synchronized (this.fLock) {
            if (this.fCompilationUnit != null) {
                try {
                    if (DEBUG) {
                        System.out.println("------------------------------------------------------------------");
                        System.out.println("(-) JsTranslation [" + this + "] discarding JavaScriptUnit: " + this.fCompilationUnit);
                        System.out.println("------------------------------------------------------------------");
                    }
                    this.fCompilationUnit.discardWorkingCopy();
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void setProblemCollectingActive(boolean collect) {
        IJavaScriptUnit cu = this.getCompilationUnit();
        if (cu != null) {
            this.getProblemRequestor().setIsActive(collect);
        }
    }

    @Override
    public void classpathChange() {
        if (this.fDocumentScope != null) {
            this.fDocumentScope.classpathChange();
        }
    }
}

