/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.team.core.diff.FastDiffFilter;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.mapping.ResourceModelTraversalCalculator;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.mapping.SynchronizationOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class ResourceModelProviderOperation
extends SynchronizationOperation {
    private final IStructuredSelection selection;

    protected ResourceModelProviderOperation(ISynchronizePageConfiguration configuration, IStructuredSelection selection) {
        super(configuration, ResourceModelProviderOperation.getElements(selection));
        this.selection = selection;
    }

    private static Object[] getElements(IStructuredSelection selection) {
        return selection.toArray();
    }

    private IDiff[] getFileDeltas(Object[] pathOrElements) {
        HashSet result = new HashSet();
        Object[] objectArray = pathOrElements;
        int n = pathOrElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object pathOrElement = objectArray[n2];
            IDiff[] diffs = this.getFileDeltas(pathOrElement);
            Collections.addAll(result, diffs);
            ++n2;
        }
        return result.toArray(new IDiff[result.size()]);
    }

    private IDiff[] getFileDeltas(Object pathOrElement) {
        ArrayList<IDiff> result = new ArrayList<IDiff>();
        ResourceTraversal[] traversals = this.getTraversals(pathOrElement);
        if (traversals.length > 0) {
            IDiff[] diffs;
            ISynchronizationContext context = this.getContext();
            IResourceDiffTree diffTree = context.getDiffTree();
            IDiff[] iDiffArray = diffs = diffTree.getDiffs(traversals);
            int n = diffs.length;
            int n2 = 0;
            while (n2 < n) {
                IDiff node = iDiffArray[n2];
                if (this.isVisible(node) && this.getDiffFilter().select(node)) {
                    result.add(node);
                }
                ++n2;
            }
        }
        return result.toArray(new IDiff[result.size()]);
    }

    protected boolean isVisible(IDiff node) {
        return ((SynchronizePageConfiguration)this.getConfiguration()).isVisible(node);
    }

    private ResourceTraversal[] getTraversals(Object pathOrElement) {
        Object element;
        if (pathOrElement instanceof TreePath) {
            TreePath tp = (TreePath)pathOrElement;
            Object o = tp.getFirstSegment();
            if (o instanceof DiffChangeSet) {
                DiffChangeSet dcs = (DiffChangeSet)o;
                return this.getTraversalCalculator().getTraversals(dcs, tp);
            }
            element = tp.getLastSegment();
        } else {
            element = pathOrElement;
        }
        if (this.isResourcePath(pathOrElement)) {
            IResource resource = (IResource)element;
            return this.getTraversalCalculator().getTraversals(resource, (TreePath)pathOrElement);
        }
        ResourceMapping mapping = Utils.getResourceMapping(element);
        if (mapping != null) {
            ResourceTraversal[] traversals = this.getContext().getScope().getTraversals(mapping);
            if (traversals != null) {
                return traversals;
            }
            try {
                return mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, null);
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
        }
        return new ResourceTraversal[0];
    }

    private boolean isResourcePath(Object pathOrElement) {
        if (pathOrElement instanceof TreePath) {
            TreePath tp = (TreePath)pathOrElement;
            return this.getTraversalCalculator().isResourcePath(tp);
        }
        return false;
    }

    protected abstract FastDiffFilter getDiffFilter();

    @Override
    public boolean shouldRun() {
        Object[] elements;
        Object[] objectArray = elements = this.getElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (Utils.getResourceMapping(this.internalGetElement(object)) != null) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected IDiff[] getTargetDiffs() {
        return this.getFileDeltas(this.getTreePathsOrElements());
    }

    private Object[] getTreePathsOrElements() {
        IStructuredSelection iStructuredSelection = this.selection;
        if (iStructuredSelection instanceof ITreeSelection) {
            ITreeSelection ts = (ITreeSelection)iStructuredSelection;
            return ts.getPaths();
        }
        return this.getElements();
    }

    @Override
    protected boolean canRunAsJob() {
        return true;
    }

    protected ResourceModelTraversalCalculator getTraversalCalculator() {
        return ResourceModelTraversalCalculator.getTraversalCalculator(this.getConfiguration());
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    @Override
    public boolean belongsTo(Object family) {
        if (family == this.getContext()) {
            return true;
        }
        return super.belongsTo(family);
    }
}

