/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.target.editor.internal;

import java.util.Comparator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.maven.model.Dependency;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.jface.databinding.swt.WidgetSideEffects;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2e.core.ui.internal.components.TextComboBoxCellEditor;
import org.eclipse.m2e.pde.target.MavenTargetDependency;
import org.eclipse.m2e.pde.ui.target.editor.Messages;
import org.eclipse.m2e.pde.ui.target.editor.internal.TargetDependencyModel;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.BorderData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

public class DependencyTable {
    private static final String[] DEFAULT_TYPES = new String[]{"jar", "bundle", "pom"};
    private final TargetDependencyModel model;
    private TableViewer viewer;

    public DependencyTable(Composite parent, TargetDependencyModel model) {
        this.model = model;
        this.createContent(parent);
    }

    private void createContent(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(5, 0).create());
        composite.setLayoutData((Object)new BorderData(131072));
        this.createButtons(composite);
        TableColumnLayout layout = new TableColumnLayout();
        composite = new Composite(parent, 0);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new BorderData(0x1000000, -1, 0));
        this.createTable(composite);
        this.createTableColumns(layout);
        this.fillTable(composite);
    }

    private void createTable(Composite parent) {
        this.viewer = new TableViewer(parent, 68354);
        this.viewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.viewer.getTable().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().addKeyListener(KeyListener.keyPressedAdapter(event -> {
            if (event.keyCode == 127 && !this.viewer.getSelection().isEmpty()) {
                this.model.remove();
            }
        }));
    }

    private void createTableColumns(TableColumnLayout layout) {
        Function<MavenTargetDependency, String> getter = Dependency::getGroupId;
        BiConsumer<MavenTargetDependency, String> setter = Dependency::setGroupId;
        TableViewerColumn tableColumn = this.newColumn(layout, Messages.MavenTargetDependencyEditor_1, getter, true);
        tableColumn.setEditingSupport(this.newEditingSupport(getter, setter, TextCellEditor::new));
        getter = Dependency::getArtifactId;
        setter = Dependency::setArtifactId;
        tableColumn = this.newColumn(layout, Messages.MavenTargetDependencyEditor_2, getter, true);
        tableColumn.setEditingSupport(this.newEditingSupport(getter, setter, TextCellEditor::new));
        getter = Dependency::getVersion;
        setter = Dependency::setVersion;
        tableColumn = this.newColumn(layout, Messages.MavenTargetDependencyEditor_3, getter, true);
        tableColumn.setEditingSupport(this.newEditingSupport(getter, setter, TextCellEditor::new));
        getter = Dependency::getClassifier;
        setter = Dependency::setClassifier;
        tableColumn = this.newColumn(layout, Messages.MavenTargetDependencyEditor_4, getter, false);
        tableColumn.setEditingSupport(this.newEditingSupport(getter, setter, TextCellEditor::new));
        getter = Dependency::getType;
        tableColumn = this.newColumn(layout, Messages.MavenTargetDependencyEditor_5, getter, true);
        tableColumn.setEditingSupport(this.newTypeEditingSupport());
    }

    private void createButtons(Composite parent) {
        ISideEffectFactory factory = WidgetSideEffects.createFactory((Widget)parent);
        this.newButton(parent, Messages.MavenTargetDependencyEditor_7, Messages.MavenTargetDependencyEditor_12, this.model::add);
        Button removeButton = this.newButton(parent, Messages.MavenTargetDependencyEditor_8, Messages.MavenTargetDependencyEditor_13, this.model::remove);
        factory.create(() -> removeButton.setEnabled(this.model.canRemove()));
        Button updateButton = this.newButton(parent, Messages.MavenTargetDependencyEditor_9, Messages.MavenTargetDependencyEditor_14, this.model::update);
        factory.create(() -> updateButton.setEnabled(this.model.canUpdate()));
        Button undoButton = this.newButton(parent, Messages.MavenTargetDependencyEditor_10, null, this.model.getHistory()::undo);
        factory.create(() -> undoButton.setEnabled(this.model.getHistory().canUndo()));
        Button redoButton = this.newButton(parent, Messages.MavenTargetDependencyEditor_11, null, this.model.getHistory()::redo);
        factory.create(() -> redoButton.setEnabled(this.model.getHistory().canRedo()));
    }

    private void fillTable(Composite parent) {
        ISideEffectFactory factory = WidgetSideEffects.createFactory((Widget)parent);
        factory.create(() -> {
            List<MavenTargetDependency> input = this.model.getTargetDependencies();
            this.viewer.setInput(input);
            this.resizeColumns();
            ViewerComparator comparator = this.viewer.getComparator();
            if (comparator != null) {
                comparator.sort((Viewer)this.viewer, input.toArray());
            }
        });
        factory.create(() -> {
            StructuredSelection newSelection = new StructuredSelection(this.model.getCurrentSelection());
            if (!newSelection.equals(this.viewer.getSelection())) {
                this.viewer.setSelection((ISelection)newSelection, this.shouldReveal());
            }
        });
        IViewerObservableList multipleSelection = ViewerProperties.multipleSelection(MavenTargetDependency.class).observe((Viewer)this.viewer);
        factory.create(() -> this.model.setCurrentSelection((List<MavenTargetDependency>)multipleSelection));
    }

    private void resizeColumns() {
        TableColumn[] tableColumnArray = this.viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn = tableColumnArray[n2];
            tableColumn.pack();
            ++n2;
        }
    }

    private Button newButton(Composite parent, String text, String tooltip, Runnable onSelection) {
        Button button = new Button(parent, 8);
        button.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        button.setText(text);
        button.setToolTipText(tooltip);
        button.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> onSelection.run()));
        return button;
    }

    private TableViewerColumn newColumn(TableColumnLayout layout, String text, final Function<MavenTargetDependency, String> getter, final boolean required) {
        TableViewerColumn tableColumn = new TableViewerColumn(this.viewer, 0);
        tableColumn.getColumn().addSelectionListener(this.newSortAdapter(getter));
        tableColumn.getColumn().setText(text);
        tableColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                String text = (String)getter.apply((MavenTargetDependency)element);
                return this.isValid(element) ? text : Messages.MavenTargetDependencyEditor_16;
            }

            public Color getForeground(Object element) {
                Color errorColor = Display.getCurrent().getSystemColor(3);
                return this.isValid(element) ? null : errorColor;
            }

            private boolean isValid(Object element) {
                return !required || !((String)getter.apply((MavenTargetDependency)element)).isBlank();
            }
        });
        layout.setColumnData((Widget)tableColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(0, false));
        return tableColumn;
    }

    private EditingSupport newTypeEditingSupport() {
        Function<Composite, CellEditor> editorFactory = composite -> {
            TextComboBoxCellEditor cellEditor = new TextComboBoxCellEditor(composite, 0);
            cellEditor.setItems(DEFAULT_TYPES);
            return cellEditor;
        };
        return this.newEditingSupport(Dependency::getType, Dependency::setType, editorFactory);
    }

    private EditingSupport newEditingSupport(final Function<MavenTargetDependency, String> getter, final BiConsumer<MavenTargetDependency, String> setter, final Function<Composite, CellEditor> editorFactory) {
        return new EditingSupport((ColumnViewer)this.viewer){

            protected CellEditor getCellEditor(Object element) {
                return (CellEditor)editorFactory.apply((Composite)this.getViewer().getControl());
            }

            protected boolean canEdit(Object element) {
                return element instanceof MavenTargetDependency;
            }

            protected String getValue(Object element) {
                return (String)getter.apply((MavenTargetDependency)element);
            }

            protected void setValue(Object element, Object value) {
                MavenTargetDependency dependency = (MavenTargetDependency)element;
                String oldValue = (String)getter.apply(dependency);
                String newValue = (String)value;
                BiConsumer<MavenTargetDependency, String> realSetter = (k, v) -> {
                    setter.accept(k, v);
                    this.getViewer().refresh();
                    DependencyTable.this.resizeColumns();
                };
                DependencyTable.this.model.modify(dependency, realSetter, oldValue, newValue);
            }
        };
    }

    private SelectionListener newSortAdapter(Function<MavenTargetDependency, String> getter) {
        return SelectionListener.widgetSelectedAdapter(e -> {
            Comparator<MavenTargetDependency> comparator;
            Table table = this.viewer.getTable();
            Comparator<MavenTargetDependency> remainingColumns = Comparator.comparing(MavenTargetDependency::getKey);
            if (table.getSortColumn() != e.widget || table.getSortDirection() == 128) {
                table.setSortDirection(1024);
                comparator = Comparator.comparing(getter).thenComparing(remainingColumns);
            } else {
                table.setSortDirection(128);
                comparator = Comparator.comparing(getter).thenComparing(remainingColumns).reversed();
            }
            table.setSortColumn((TableColumn)e.widget);
            this.viewer.setComparator(new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    return comparator.compare((MavenTargetDependency)e1, (MavenTargetDependency)e2);
                }
            });
            this.viewer.refresh();
        });
    }

    private boolean shouldReveal() {
        for (MavenTargetDependency dependency : this.model.getCurrentSelection()) {
            int index = this.model.getTargetDependencies().indexOf(dependency);
            int rowHeight = this.viewer.getTable().getItemHeight();
            int rowOffset = index * rowHeight;
            Rectangle clientArea = this.viewer.getTable().getClientArea();
            if (rowOffset >= clientArea.y && rowOffset + rowHeight <= clientArea.y + clientArea.height) continue;
            return true;
        }
        return false;
    }
}

