/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.ui.task;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jst.ws.internal.axis.consumption.ui.AxisConsumptionUIMessages;
import org.eclipse.jst.ws.internal.axis.consumption.ui.plugin.WebServiceAxisConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.core.context.TransientResourceContext;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.common.BundleUtils;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class CopyAxisJarCommand
extends AbstractDataModelOperation {
    public static String AXIS_JAR = "axis.jar";
    public static String AXIS_RUNTIME_PLUGIN_ID = "org.apache.axis";
    public static String COMMON_DISCOVERY_PLUGIN_ID = "org.apache.commons.discovery";
    public static String COMMON_DISCOVERY_JAR = "commons-discovery-0.2.jar";
    public static String JAVAX_XML_RPC_PLUGIN_ID = "javax.xml.rpc";
    public static String JAVAX_XML_RPC_JAR = "jaxrpc.jar";
    public static String JAVAX_XML_SOAP_PLUGIN_ID = "javax.xml.soap";
    public static Version JAVAX_XML_SOAP_PLUGIN_VERSION = Version.parseVersion((String)"1.2.0");
    private static Version JAVAX_XML_SOAP_PLUGIN_UPPER_VERSION = Version.parseVersion((String)"1.3.0");
    public static String JAVAX_XML_SOAP_JAR = "saaj.jar";
    public static String JAVAX_WSDL_PLUGIN_ID = "javax.wsdl";
    public static String JAVAX_WSDL_JAR = "wsdl4j.jar";
    public static String COMMON_LOGGING_PLUGIN_ID = "org.apache.commons.logging";
    public static String COMMON_LOGGING_JAR = "commons-logging.jar";
    private static long AXIS_JAR_SIZE = 1599570L;
    private static long COMMON_DISCOVERY_JAR_SIZE = 71442L;
    private static long JAVAX_XML_RPC_JAR_SIZE = 31191L;
    private static long JAVAX_XML_SOAP_JAR_SIZE = 18979L;
    private static long JAVAX_WSDL_JAR_SIZE = 168178L;
    private static long COMMON_LOGGING_JAR_SIZE = 44210L;
    private static String[] OBSOLETE_JARS = new String[]{"commons-discovery.jar", "commons-logging-1.0.4.jar", "log4j-1.2.4.jar", "log4j-1.2.8.jar", "wsdl4j-1.5.1.jar", "axis-ant.jar"};
    public static String PATH_TO_JARS_IN_PLUGIN = "lib/";
    private IProject project;
    private Boolean projectRestartRequired_ = Boolean.FALSE;
    private IClasspathEntry[] oldClasspath;
    private ArrayList newJarNamesList = new ArrayList();

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        if (WebServiceAxisConsumptionUIPlugin.getInstance().getPluginPreferences().getBoolean("disableAxisJarCopy")) {
            return Status.OK_STATUS;
        }
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        ProgressUtils.report((IProgressMonitor)monitor, (String)AxisConsumptionUIMessages.PROGRESS_INFO_COPY_AXIS_CFG);
        if (J2EEUtils.isWebComponent((IProject)this.project)) {
            this.copyAxisJarsToProject(this.project, status, env, monitor);
        } else if (J2EEUtils.isJavaComponent((IProject)this.project)) {
            status = this.addAxisJarsToBuildPath(this.project, env, monitor);
            if (status.getSeverity() == 4) {
                env.getStatusHandler().reportError(status);
                return status;
            }
        } else {
            status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_WARN_NO_JAVA_NATURE);
            env.getStatusHandler().reportError(status);
            return status;
        }
        return status;
    }

    private void copyAxisJarsToProject(IProject project, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        IPath webModulePath = J2EEUtils.getWebContentPath((IProject)project);
        if (webModulePath == null) {
            status = StatusUtils.errorStatus((String)ConsumptionMessages.MSG_ERROR_PROJECT_NOT_FOUND);
            env.getStatusHandler().reportError(status);
            return;
        }
        this.deleteObsoleteJars(webModulePath);
        this.copyIFile(AXIS_RUNTIME_PLUGIN_ID, null, null, "lib/" + AXIS_JAR, webModulePath, "WEB-INF/lib/" + AXIS_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
        this.copyIFile(COMMON_DISCOVERY_PLUGIN_ID, null, null, "lib/" + COMMON_DISCOVERY_JAR, webModulePath, "WEB-INF/lib/" + COMMON_DISCOVERY_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
        this.copyIFile(JAVAX_XML_RPC_PLUGIN_ID, null, null, "lib/" + JAVAX_XML_RPC_JAR, webModulePath, "WEB-INF/lib/" + JAVAX_XML_RPC_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
        this.copyIFile(JAVAX_XML_SOAP_PLUGIN_ID, JAVAX_XML_SOAP_PLUGIN_VERSION, JAVAX_XML_SOAP_PLUGIN_UPPER_VERSION, "lib/" + JAVAX_XML_SOAP_JAR, webModulePath, "WEB-INF/lib/" + JAVAX_XML_SOAP_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
        this.copyPluginJar(JAVAX_WSDL_PLUGIN_ID, webModulePath, "WEB-INF/lib/" + JAVAX_WSDL_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
        this.copyPluginJar(COMMON_LOGGING_PLUGIN_ID, webModulePath, "WEB-INF/lib/" + COMMON_LOGGING_JAR, status, env, monitor);
        if (status.getSeverity() == 4) {
            return;
        }
    }

    private void copyIFile(String pluginId, Version pluginVersion, Version upperVersion, String source, IPath targetPath, String targetFile, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        IPath target = targetPath.append((IPath)new Path(targetFile));
        ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_COPYING_FILE);
        try {
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            URL sourceURL = null;
            sourceURL = pluginVersion != null ? BundleUtils.getURLFromBundle((String)pluginId, (Version)pluginVersion, (Version)upperVersion, (String)source) : BundleUtils.getURLFromBundle((String)pluginId, (String)source);
            IFile resource = ResourceUtils.getWorkspaceRoot().getFile(target);
            if (!resource.exists()) {
                IFile file = FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)sourceURL.openStream(), (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
                if (!this.projectRestartRequired_.booleanValue() && file.exists()) {
                    this.projectRestartRequired_ = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_FILECOPY, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    private void copyPluginJar(String pluginId, IPath targetPath, String targetFile, IStatus status, IEnvironment env, IProgressMonitor monitor) {
        IPath target = targetPath.append((IPath)new Path(targetFile));
        ProgressUtils.report((IProgressMonitor)monitor, (String)ConsumptionMessages.PROGRESS_INFO_COPYING_FILE);
        try {
            IFile resource;
            TransientResourceContext context = new TransientResourceContext();
            context.setOverwriteFilesEnabled(true);
            context.setCreateFoldersEnabled(true);
            context.setCheckoutFilesEnabled(true);
            File jarFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)pluginId));
            if (jarFile != null && jarFile.isFile() && !(resource = ResourceUtils.getWorkspaceRoot().getFile(target)).exists()) {
                FileInputStream is = new FileInputStream(jarFile);
                IFile file = FileResourceUtils.createFile((ResourceContext)context, (IPath)target, (InputStream)is, (IProgressMonitor)monitor, (IStatusHandler)env.getStatusHandler());
                if (!this.projectRestartRequired_.booleanValue() && file.exists()) {
                    this.projectRestartRequired_ = Boolean.TRUE;
                }
            }
        }
        catch (Exception e) {
            status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_FILECOPY, (Throwable)e);
            env.getStatusHandler().reportError(status);
        }
    }

    private void deleteObsoleteJars(IPath webModulePath) {
        int i = 0;
        while (i < OBSOLETE_JARS.length) {
            IPath path = webModulePath.append("WEB-INF/lib/" + OBSOLETE_JARS[i]);
            IFile resource = ResourceUtils.getWorkspaceRoot().getFile(path);
            if (resource.exists()) {
                this.deleteResource(resource);
            }
            ++i;
        }
        this.deleteOldJar(webModulePath.append("WEB-INF/lib/" + AXIS_JAR), AXIS_JAR_SIZE);
        this.deleteOldJar(webModulePath.append("WEB-INF/lib/" + COMMON_DISCOVERY_JAR), COMMON_DISCOVERY_JAR_SIZE);
        this.deleteOldJar(webModulePath.append("WEB-INF/lib/" + JAVAX_XML_RPC_JAR), JAVAX_XML_RPC_JAR_SIZE);
        this.deleteOldJar(webModulePath.append("WEB-INF/lib/" + JAVAX_XML_SOAP_JAR), JAVAX_XML_SOAP_JAR_SIZE);
        this.deleteOldJar(webModulePath.append("WEB-INF/lib/" + JAVAX_WSDL_JAR), JAVAX_WSDL_JAR_SIZE);
        this.deleteOldJar(webModulePath.append("WEB-INF/lib/" + COMMON_LOGGING_JAR), COMMON_LOGGING_JAR_SIZE);
    }

    private void deleteOldJar(IPath jarPath, long jarSize) {
        long fileSize;
        IFile resource = ResourceUtils.getWorkspaceRoot().getFile(jarPath);
        if (resource.exists() && (fileSize = resource.getLocation().toFile().length()) != jarSize) {
            this.deleteResource(resource);
        }
    }

    private void deleteResource(IFile resource) {
        try {
            resource.delete(true, null);
        }
        catch (Exception exception) {}
    }

    public IStatus addAxisJarsToBuildPath(IProject project, IEnvironment env, IProgressMonitor monitor) {
        try {
            IPath commonLoggingJarPath;
            this.getJavaProjectClasspath(env, monitor);
            this.addNewJarEntry(String.valueOf(PATH_TO_JARS_IN_PLUGIN) + AXIS_JAR, this.getTheJarPath(AXIS_RUNTIME_PLUGIN_ID, String.valueOf(PATH_TO_JARS_IN_PLUGIN) + AXIS_JAR));
            this.addNewJarEntry(String.valueOf(PATH_TO_JARS_IN_PLUGIN) + COMMON_DISCOVERY_JAR, this.getTheJarPath(COMMON_DISCOVERY_PLUGIN_ID, String.valueOf(PATH_TO_JARS_IN_PLUGIN) + COMMON_DISCOVERY_JAR));
            this.addNewJarEntry(String.valueOf(PATH_TO_JARS_IN_PLUGIN) + JAVAX_XML_RPC_JAR, this.getTheJarPath(JAVAX_XML_RPC_PLUGIN_ID, String.valueOf(PATH_TO_JARS_IN_PLUGIN) + JAVAX_XML_RPC_JAR));
            this.addNewJarEntry(String.valueOf(PATH_TO_JARS_IN_PLUGIN) + JAVAX_XML_SOAP_JAR, this.getTheJarPath(JAVAX_XML_SOAP_PLUGIN_ID, String.valueOf(PATH_TO_JARS_IN_PLUGIN) + JAVAX_XML_SOAP_JAR));
            IPath javaxWsdlJarPath = BundleUtils.getJarredPluginPath((String)JAVAX_WSDL_PLUGIN_ID);
            if (javaxWsdlJarPath != null) {
                this.addNewJarEntry(javaxWsdlJarPath.toString(), javaxWsdlJarPath);
            }
            if ((commonLoggingJarPath = BundleUtils.getJarredPluginPath((String)COMMON_LOGGING_PLUGIN_ID)) != null) {
                this.addNewJarEntry(commonLoggingJarPath.toString(), commonLoggingJarPath);
            }
            this.updateClasspath(monitor);
        }
        catch (Exception e) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionUIMessages.MSG_ERROR_BAD_BUILDPATH, (Throwable)e);
            return status;
        }
        return Status.OK_STATUS;
    }

    private IStatus getJavaProjectClasspath(IEnvironment env, IProgressMonitor monitor) throws JavaModelException {
        IStatus status = Status.OK_STATUS;
        IJavaProject javaProject_ = null;
        this.oldClasspath = null;
        javaProject_ = JavaCore.create((IProject)this.project);
        this.oldClasspath = javaProject_.getRawClasspath();
        return status;
    }

    private void addNewJarEntry(String jarName, IPath jarPath) {
        boolean found = false;
        int i = 0;
        while (i < this.oldClasspath.length) {
            found = this.oldClasspath[i].getPath().toString().toLowerCase().endsWith(jarName.toLowerCase());
            if (found) break;
            ++i;
        }
        if (!found) {
            this.newJarNamesList.add(new JarEntry(jarName, jarPath));
        }
    }

    private IStatus updateClasspath(IProgressMonitor monitor) throws JavaModelException {
        IStatus status = Status.OK_STATUS;
        if (this.newJarNamesList.size() > 0) {
            JarEntry[] newJarEntries = this.newJarNamesList.toArray(new JarEntry[0]);
            IClasspathEntry[] newClasspath = new IClasspathEntry[this.oldClasspath.length + newJarEntries.length];
            int i = 0;
            while (i < this.oldClasspath.length) {
                newClasspath[i] = this.oldClasspath[i];
                ++i;
            }
            int m = 0;
            while (i < newClasspath.length) {
                newClasspath[i] = JavaCore.newLibraryEntry((IPath)newJarEntries[m].getJarPath(), null, null);
                ++m;
                ++i;
            }
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            javaProject.setRawClasspath(newClasspath, monitor);
        }
        return status;
    }

    private IPath getTheJarPath(String pluginId, String theJar) throws MalformedURLException, IOException {
        if (pluginId != null) {
            URL localURL = Platform.asLocalURL((URL)BundleUtils.getURLFromBundle((String)pluginId, (String)theJar));
            return new Path(localURL.getFile());
        }
        return new Path(theJar);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public boolean getProjectRestartRequired() {
        return this.projectRestartRequired_;
    }

    public class JarEntry {
        private String jarName;
        private IPath jarPath;

        public JarEntry(String name, IPath path) {
            this.jarName = name;
            this.jarPath = path;
        }

        public String getJarName() {
            return this.jarName;
        }

        public IPath getJarPath() {
            return this.jarPath;
        }
    }
}

