/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.update;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.QueryUpdateStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryModelFactory;
import org.eclipse.datatools.modelbase.sql.query.TableExpression;
import org.eclipse.datatools.modelbase.sql.query.TableInDatabase;
import org.eclipse.datatools.modelbase.sql.query.UpdateAssignmentExpression;
import org.eclipse.datatools.modelbase.sql.query.UpdateSource;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.modelbase.sql.query.helper.TableHelper;
import org.eclipse.datatools.modelbase.sql.query.impl.SQLQueryModelFactoryImpl;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.UpdateHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ObjectListHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.views.update.UpdateTreeElement;
import org.eclipse.datatools.sqltools.sqlbuilder.views.update.UpdateTreeViewer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class UpdateDesignViewer
extends ContentViewer
implements ISelectionProvider,
ISelectionChangedListener {
    QueryUpdateStatement update;
    SQLDomainModel domainModel;
    Composite canvas;
    org.eclipse.swt.widgets.List setContentList;
    ObjectListHelper setContentHelper;
    String[] listSelections;
    int selectionNumber = 0;
    Button addButton;
    Button groupButton;
    Button removeButton;
    SQLQueryModelFactory factory = SQLQueryModelFactoryImpl.eINSTANCE;
    UpdateTreeViewer updateTreeViewer;
    Object element;
    VendorHelper vendorHelper;
    protected Vector selectionListenerList = new Vector();

    public UpdateDesignViewer(SQLDomainModel sqlDomainModel) {
        this.domainModel = sqlDomainModel;
        this.vendorHelper = new VendorHelper(this.domainModel.getDatabase());
        this.setContentProvider((IContentProvider)this.domainModel.createContentProvider());
        this.update = null;
    }

    public void setInput(Object input) {
        if (input instanceof QueryUpdateStatement) {
            this.update = (QueryUpdateStatement)input;
            this.initializeView();
            this.updateTreeViewer.setInput(input);
        }
        super.setInput(input);
    }

    public Control createControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        this.canvas = sashForm;
        this.setContentList = new org.eclipse.swt.widgets.List(this.canvas, 2818);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.setContentList, "org.eclipse.datatools.sqltools.sqlbuilder.sqdu0020");
        this.setContentHelper = new ObjectListHelper(this.setContentList);
        SetContentListener setContentListener = new SetContentListener();
        this.setContentList.addListener(13, (Listener)setContentListener);
        Composite buttonPanel = ViewUtility.createComposite(this.canvas, 1, true);
        this.addButton = ViewUtility.createPushButton(buttonPanel, ">");
        ButtonSelectListener addButtonListener = new ButtonSelectListener();
        this.addButton.addSelectionListener((SelectionListener)addButtonListener);
        this.addButton.setToolTipText(Messages._UI_TOOLTIP_UPDATE_ADD_COL);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addButton, "org.eclipse.datatools.sqltools.sqlbuilder.sqdu0020");
        this.removeButton = ViewUtility.createPushButton(buttonPanel, "<");
        ButtonSelectListener removeButtonListener = new ButtonSelectListener();
        this.removeButton.addSelectionListener((SelectionListener)removeButtonListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.removeButton, "org.eclipse.datatools.sqltools.sqlbuilder.sqdu0020");
        this.groupButton = ViewUtility.createPushButton(buttonPanel, ">");
        this.groupButton.setImage(SQLBuilderPlugin.getPlugin().getImage("icons/columngroup.gif"));
        this.groupButton.setToolTipText(Messages._UI_TOOLTIP_UPDATE_ADD_GRP);
        ButtonSelectListener groupButtonListener = new ButtonSelectListener();
        this.groupButton.addSelectionListener((SelectionListener)groupButtonListener);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.groupButton, "org.eclipse.datatools.sqltools.sqlbuilder.sqdu0020");
        this.updateTreeViewer = new UpdateTreeViewer(this.domainModel, this.canvas);
        this.updateTreeViewer.setInput(null);
        this.updateTreeViewer.addSelectionChangedListener(this);
        sashForm.setWeights(new int[]{35, 10, 55});
        this.hookControl((Control)this.canvas);
        return this.getControl();
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    protected void initializeView() {
        if (this.update != null) {
            if (this.update.getTargetTable() != null) {
                this.populateSetList();
            } else {
                this.setContentList.removeAll();
            }
        }
        this.setContentHelper.deselectAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.groupButton.setEnabled(false);
    }

    protected void populateSetList() {
        Vector<String> availColNames = new Vector<String>();
        TableInDatabase tableExpr = this.update.getTargetTable();
        Iterator columnsItr = tableExpr.getColumnList().iterator();
        List targetColList = UpdateHelper.getTargetColumns(this.update);
        while (columnsItr.hasNext()) {
            ValueExpressionColumn currentValExprCol = (ValueExpressionColumn)columnsItr.next();
            String currentName = currentValExprCol.getName();
            if (targetColList != null) {
                Iterator targetListItr = targetColList.iterator();
                boolean found = false;
                while (!found && targetListItr.hasNext()) {
                    String targetName = ((ValueExpressionColumn)targetListItr.next()).getName();
                    if (!currentName.equals(targetName)) continue;
                    found = true;
                }
                if (found) continue;
                availColNames.add(currentName);
                continue;
            }
            availColNames.add(currentName);
        }
        String[] listColumns = new String[availColNames.size()];
        Iterator addColumns = availColNames.iterator();
        int count = 0;
        while (addColumns.hasNext()) {
            String nextCol;
            listColumns[count] = nextCol = (String)addColumns.next();
            ++count;
        }
        this.setContentList.setItems(listColumns);
    }

    Column findSelectionInColumnList(String selection, Iterator columnList) {
        Column result = null;
        while (columnList.hasNext()) {
            ValueExpressionColumn columnExpression = (ValueExpressionColumn)columnList.next();
            Column currentColumn = TableHelper.getColumnForColumnExpression((TableExpression)ExpressionHelper.getTableExprForValueExpressionColumn(columnExpression), (ValueExpressionColumn)columnExpression);
            String columnName = currentColumn.getName();
            if (!columnName.equals(selection)) continue;
            result = currentColumn;
            break;
        }
        return result;
    }

    public Control getControl() {
        return this.canvas;
    }

    public Object getInput() {
        return this.update;
    }

    public void refresh() {
        if (this.getInput() != null) {
            this.initializeView();
        }
    }

    public void inputChanged(Object newElement, Object oldElement) {
        this.initializeView();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListenerList.add(listener);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selection = ((StructuredSelection)this.updateTreeViewer.getSelection()).getFirstElement();
        if (selection instanceof UpdateTreeElement) {
            UpdateTreeElement treeElement = (UpdateTreeElement)selection;
            if (treeElement != null) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
        this.notifySelectionChanged(event);
    }

    public void notifySelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener listener : this.selectionListenerList) {
            listener.selectionChanged(event);
        }
    }

    public void setEnabled(boolean enable) {
        if (enable) {
            this.setContentList.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            this.setContentList.setBackground(this.canvas.getBackground());
        }
        this.updateTreeViewer.setEnabled(enable);
    }

    class ButtonSelectListener
    implements SelectionListener {
        ButtonSelectListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            TableInDatabase tableExpr = UpdateDesignViewer.this.update.getTargetTable();
            if (e.widget == UpdateDesignViewer.this.addButton) {
                Column column = TableHelper.getColumnForName((TableInDatabase)tableExpr, (String)UpdateDesignViewer.this.listSelections[0]);
                if (column != null) {
                    UpdateHelper.addColumn(UpdateDesignViewer.this.update, column);
                }
            } else if (e.widget == UpdateDesignViewer.this.groupButton) {
                ArrayList<Column> columns = new ArrayList<Column>();
                int i = 0;
                while (i < UpdateDesignViewer.this.selectionNumber) {
                    Column column = TableHelper.getColumnForName((TableInDatabase)tableExpr, (String)UpdateDesignViewer.this.listSelections[i]);
                    if (column != null) {
                        columns.add(column);
                    }
                    ++i;
                }
                if (!columns.isEmpty()) {
                    UpdateHelper.addColumns(UpdateDesignViewer.this.update, columns);
                }
            } else if (e.widget == UpdateDesignViewer.this.removeButton) {
                Object selection = ((StructuredSelection)UpdateDesignViewer.this.updateTreeViewer.getSelection()).getFirstElement();
                UpdateTreeElement localElement = (UpdateTreeElement)selection;
                UpdateSource source = localElement.getUpdateSource();
                if (localElement.hasChildren()) {
                    if (source != null) {
                        EList exprList = UpdateDesignViewer.this.update.getAssignmentClause();
                        UpdateAssignmentExpression expr = source.getUpdateAssignmentExpr();
                        exprList.remove(expr);
                    }
                } else {
                    ValueExpressionColumn selectedColumn = ((UpdateTreeElement)selection).getRDBColumn();
                    if (selectedColumn != null) {
                        UpdateHelper.removeColumn(UpdateDesignViewer.this.update, selectedColumn);
                    }
                }
            }
            UpdateDesignViewer.this.refresh();
            UpdateDesignViewer.this.updateTreeViewer.refresh();
            UpdateDesignViewer.this.updateTreeViewer.setInput(UpdateDesignViewer.this.update);
            UpdateDesignViewer.this.setContentHelper.deselectAll();
        }
    }

    class SetContentListener
    implements Listener {
        SetContentListener() {
        }

        public void handleEvent(Event e) {
            UpdateDesignViewer.this.selectionNumber = UpdateDesignViewer.this.setContentHelper.getSelectionCount();
            UpdateDesignViewer.this.listSelections = UpdateDesignViewer.this.setContentHelper.getSelection();
            if (UpdateDesignViewer.this.selectionNumber == 1) {
                UpdateDesignViewer.this.addButton.setEnabled(true);
                this.enableGroupButton();
            } else if (UpdateDesignViewer.this.selectionNumber > 1) {
                UpdateDesignViewer.this.addButton.setEnabled(false);
                this.enableGroupButton();
            } else {
                UpdateDesignViewer.this.addButton.setEnabled(false);
                UpdateDesignViewer.this.groupButton.setEnabled(false);
            }
        }

        private void enableGroupButton() {
            if (!UpdateDesignViewer.this.vendorHelper.isCloudscape() && !UpdateDesignViewer.this.vendorHelper.isSybase()) {
                UpdateDesignViewer.this.groupButton.setEnabled(true);
            }
        }
    }
}

