/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.AbstractViewer;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class BinaryCompareViewer
extends AbstractViewer {
    private static final String BUNDLE_NAME = "org.eclipse.compare.internal.BinaryCompareViewerResources";
    private static final int EOF = -1;
    private ICompareInput fInput;
    private final ResourceBundle fBundle;
    private final Composite fComposite;
    private final Label fMessage;
    private final CompareConfiguration compareConfiguration;

    public BinaryCompareViewer(Composite parent, CompareConfiguration cc) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.compare.binary_compare_view_context");
        }
        this.fBundle = ResourceBundle.getBundle(BUNDLE_NAME);
        this.fComposite = new Composite(parent, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.type = 512;
        this.fComposite.setLayout((Layout)rowLayout);
        this.fMessage = new Label(this.fComposite, 64);
        this.fComposite.setData("org.eclipse.compare.CompareUI.CompareViewerTitle", (Object)Utilities.getString(this.fBundle, "title"));
        CompareConfiguration compareConfiguration = this.compareConfiguration = cc != null ? cc : new CompareConfiguration();
        if (this.compareConfiguration.getContainer() instanceof CompareEditorInput) {
            Label compareAsTextLabel = new Label(this.fComposite, 64);
            compareAsTextLabel.setText(Utilities.getString(this.fBundle, "compareAsText"));
        }
    }

    public Control getControl() {
        return this.fComposite;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setInput(Object input) {
        String message;
        block24: {
            if (this.fComposite == null) return;
            if (!(input instanceof ICompareInput)) return;
            this.fInput = (ICompareInput)input;
            message = null;
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try {
                    InputStream left = this.getStream(this.fInput.getLeft());
                    try {
                        block23: {
                            try (InputStream right = this.getStream(this.fInput.getRight());){
                                if (left != null && right != null) {
                                    int pos = 0;
                                    while (true) {
                                        int r;
                                        int l;
                                        if ((l = left.read()) != (r = right.read())) {
                                            String format = Utilities.getString(this.fBundle, "diffMessageFormat");
                                            message = MessageFormat.format(format, Integer.toString(pos));
                                            break block23;
                                        } else if (l != -1) {
                                            ++pos;
                                            continue;
                                        }
                                        break block23;
                                        break;
                                    }
                                }
                                if (left == null && right == null) {
                                    message = Utilities.getString(this.fBundle, "deleteConflictMessage");
                                    break block23;
                                }
                                if (left == null) {
                                    message = Utilities.getString(this.fBundle, this.compareConfiguration.isMirrored() ? "addedMessage" : "deletedMessage");
                                    break block23;
                                }
                                if (right == null) {
                                    message = Utilities.getString(this.fBundle, this.compareConfiguration.isMirrored() ? "deletedMessage" : "addedMessage");
                                }
                            }
                        }
                        if (left == null) break block24;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (left == null) throw throwable;
                        left.close();
                        throw throwable;
                    }
                    left.close();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }
            catch (IOException | CoreException ex) {
                message = Utilities.getString(this.fBundle, "errorMessage");
                CompareUIPlugin.log(ex);
            }
        }
        if (message != null) {
            this.fMessage.setText(message);
        }
        this.fComposite.layout();
    }

    @Override
    public Object getInput() {
        return this.fInput;
    }

    private InputStream getStream(ITypedElement input) throws CoreException {
        if (input instanceof IStreamContentAccessor) {
            return ((IStreamContentAccessor)((Object)input)).getContents();
        }
        return null;
    }
}

