/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions;

import java.util.List;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.domain.IMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.AbstractMergeRunnable;
import org.eclipse.emf.compare.ide.ui.internal.structuremergeviewer.actions.MergeConflictingRunnable;
import org.eclipse.emf.compare.internal.merge.MergeMode;
import org.eclipse.emf.compare.merge.IDiffRelationshipComputer;
import org.eclipse.emf.compare.merge.IMerger;

public class MergeContainedRunnable
extends AbstractMergeRunnable
implements IMergeRunnable {
    private final MergeConflictingRunnable conflictsMergers;

    public MergeContainedRunnable(boolean isLeftEditable, boolean isRightEditable, MergeMode mergeMode, IDiffRelationshipComputer diffRelationshipComputer) {
        super(isLeftEditable, isRightEditable, mergeMode, diffRelationshipComputer);
        this.conflictsMergers = new MergeConflictingRunnable(isLeftEditable, isRightEditable, mergeMode.inverse(), diffRelationshipComputer);
    }

    public void merge(List<? extends Diff> differences, boolean leftToRight, IMerger.Registry mergerRegistry) {
        boolean mergeDiffs;
        if (this.getMergeMode().isLeftToRight(this.isLeftEditable(), this.isRightEditable()) != leftToRight) {
            throw new IllegalStateException();
        }
        this.conflictsMergers.merge(differences, leftToRight, mergerRegistry);
        switch (this.getMergeMode()) {
            case LEFT_TO_RIGHT: 
            case ACCEPT: {
                mergeDiffs = false;
                break;
            }
            default: {
                mergeDiffs = true;
            }
        }
        if (mergeDiffs) {
            this.mergeAll(differences, false, mergerRegistry);
        } else {
            differences.stream().filter(d -> d.getSource() == DifferenceSource.LEFT).forEach(d -> this.markAsMerged((Diff)d, MergeMode.ACCEPT, mergerRegistry));
            differences.stream().filter(d -> d.getSource() == DifferenceSource.RIGHT).forEach(d -> this.markAsMerged((Diff)d, MergeMode.REJECT, mergerRegistry));
        }
    }

    private void markAsMerged(Diff diff, MergeMode mode, IMerger.Registry mergerRegistry) {
        boolean isLeftToRight = mode.isLeftToRight(diff, this.isLeftEditable(), this.isRightEditable());
        this.markAsMerged(diff, mode, !isLeftToRight, mergerRegistry);
    }
}

