/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardOperation;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupport;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.MergedEObjectInfo;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ResourceInfo;

public abstract class BasePasteOperation
extends ClipboardOperation {
    public static final String PASTE = "paste";
    private Map loadOptionsMap;
    private ResourceInfo resourceInfo;
    private BasePasteOperation spawningPasteOperation;
    private Map mergedElementsMap;
    private Map unmodifiableMergedElementsMap;
    private Set pastedElementSet;
    private Set unmodifiablePastedElementSet;
    private Set criticalResolveFailuresSet;
    private Set unmodifiableCriticalResolveFailuresSet;
    private Set pasteFailuresObjectSet;
    private Set unmodifiablePasteFailuresObjectSet;

    public BasePasteOperation(IProgressMonitor monitor, Map loadOptionsMap, ResourceInfo resourceInfo, IClipboardSupport clipboardSupport) {
        super(monitor, clipboardSupport);
        this.loadOptionsMap = loadOptionsMap;
        this.resourceInfo = resourceInfo;
        this.mergedElementsMap = new HashMap();
        this.pastedElementSet = new HashSet();
        this.pasteFailuresObjectSet = new HashSet();
        this.criticalResolveFailuresSet = new HashSet();
    }

    public BasePasteOperation(BasePasteOperation spawningPasteOperation) {
        this(spawningPasteOperation.getProgressMonitor(), spawningPasteOperation.getLoadOptionsMap(), spawningPasteOperation.getResourceInfo(), spawningPasteOperation.getClipboardOperationHelper());
        this.spawningPasteOperation = spawningPasteOperation;
    }

    protected final ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    protected final Map getLoadOptionsMap() {
        return this.loadOptionsMap;
    }

    public abstract void paste() throws Exception;

    public BasePasteOperation getSpawningPasteOperation() {
        return this.spawningPasteOperation;
    }

    public final Set getAllCriticalResolveFailuresSet() {
        if (this.getSpawningPasteOperation() != null) {
            return this.getSpawningPasteOperation().getAllCriticalResolveFailuresSet();
        }
        return this.getCriticalResolveFailuresSet();
    }

    public final Map getAllMergedElementsMap() {
        if (this.getSpawningPasteOperation() != null) {
            return this.getSpawningPasteOperation().getAllMergedElementsMap();
        }
        return this.getMergedElementsMap();
    }

    public final Set getAllPastedElementSet() {
        if (this.getSpawningPasteOperation() != null) {
            return this.getSpawningPasteOperation().getAllPastedElementSet();
        }
        return this.getPastedElementSet();
    }

    public final Set getCriticalResolveFailuresSet() {
        if (this.unmodifiableCriticalResolveFailuresSet == null) {
            this.unmodifiableCriticalResolveFailuresSet = Collections.unmodifiableSet(this.criticalResolveFailuresSet);
        }
        return this.unmodifiableCriticalResolveFailuresSet;
    }

    protected void addCriticalResolveFailure(EObject nonResolvedObject) {
        this.criticalResolveFailuresSet.add(nonResolvedObject);
        if (this.getSpawningPasteOperation() != null) {
            this.getSpawningPasteOperation().addCriticalResolveFailure(nonResolvedObject);
        }
    }

    protected void removeCriticalResolveFailure(EObject newlyResolvedObject) {
        if (this.criticalResolveFailuresSet.remove(newlyResolvedObject) && this.getSpawningPasteOperation() != null) {
            this.getSpawningPasteOperation().removeCriticalResolveFailure(newlyResolvedObject);
        }
    }

    public final Map getMergedElementsMap() {
        if (this.unmodifiableMergedElementsMap == null) {
            this.unmodifiableMergedElementsMap = Collections.unmodifiableMap(this.mergedElementsMap);
        }
        return this.unmodifiableMergedElementsMap;
    }

    protected void addMergedElementEntry(EObject mergedObject, MergedEObjectInfo mergedEObjectInfo) {
        this.mergedElementsMap.put(mergedObject, mergedEObjectInfo);
        if (this.getSpawningPasteOperation() != null) {
            this.getSpawningPasteOperation().addMergedElementEntry(mergedObject, mergedEObjectInfo);
        }
    }

    public final Set getPastedElementSet() {
        if (this.unmodifiablePastedElementSet == null) {
            this.unmodifiablePastedElementSet = Collections.unmodifiableSet(this.pastedElementSet);
        }
        return this.unmodifiablePastedElementSet;
    }

    protected void addPastedElement(EObject pastedElement) {
        this.pastedElementSet.add(pastedElement);
        if (this.getSpawningPasteOperation() != null) {
            this.getSpawningPasteOperation().addPastedElement(pastedElement);
        }
    }

    public final Set getPasteFailuresObjectSet() {
        if (this.unmodifiablePasteFailuresObjectSet == null) {
            this.unmodifiablePasteFailuresObjectSet = Collections.unmodifiableSet(this.pasteFailuresObjectSet);
        }
        return this.unmodifiablePasteFailuresObjectSet;
    }

    protected void addPasteFailuresObject(EObject eObject) {
        this.pasteFailuresObjectSet.add(eObject);
        if (this.getSpawningPasteOperation() != null) {
            this.getSpawningPasteOperation().addPasteFailuresObject(eObject);
        }
    }

    public final Set getAllPasteFailuresObjectSet() {
        if (this.getSpawningPasteOperation() != null) {
            return this.getSpawningPasteOperation().getAllPasteFailuresObjectSet();
        }
        return this.getPasteFailuresObjectSet();
    }

    protected void throwCancelException() {
        this.throwCancelException(PASTE);
    }
}

