/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.assist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.templates.Template;

public class Templates {
    private String markupLanguageName;
    private final List<Template> template = new ArrayList<Template>();
    private final Set<Template> blockTemplates = new HashSet<Template>();
    private Templates parent;

    public void setMarkupLanguageName(String markupLanguageName) {
        this.markupLanguageName = markupLanguageName;
    }

    public String getMarkupLanguageName() {
        return this.markupLanguageName;
    }

    public List<Template> getTemplate() {
        if (this.parent != null) {
            List<Template> parentTemplate = this.parent.getTemplate();
            ArrayList<Template> list = new ArrayList<Template>(this.template.size() + parentTemplate.size());
            list.addAll(parentTemplate);
            list.addAll(this.template);
            return Collections.unmodifiableList(list);
        }
        return Collections.unmodifiableList(this.template);
    }

    public void addTemplate(Template template, boolean block) {
        this.template.add(template);
        if (block) {
            this.blockTemplates.add(template);
        }
    }

    public void addAll(Templates other) {
        this.template.addAll(other.template);
        this.blockTemplates.addAll(other.template);
    }

    public boolean isBlock(Template template) {
        return this.blockTemplates.contains(template) || this.parent != null && this.parent.isBlock(template);
    }

    public Templates getParent() {
        return this.parent;
    }

    public void setParent(Templates parent) {
        this.parent = parent;
    }
}

