/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.reviews.internal.core;

import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReview;
import org.eclipse.mylyn.reviews.core.model.IReviewItemSet;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class ReviewFileCommentsMapper {
    public static final String FILE_ITEM_COMMENTS = "FILE-COMMENTS";
    private final IReview review;

    public ReviewFileCommentsMapper(IReview review) {
        this.review = review;
    }

    public void applyTo(TaskData taskData) {
        TaskAttribute comments = this.getOrCreateAttribute(taskData.getRoot(), FILE_ITEM_COMMENTS);
        for (IReviewItemSet set : this.review.getSets()) {
            for (IFileItem file : set.getItems()) {
                for (IComment comment : file.getAllComments()) {
                    TaskAttribute commentAttribute = this.getOrCreateAttribute(comments, comment.getId());
                    commentAttribute.setValue(comment.getDescription());
                }
            }
        }
    }

    private TaskAttribute getOrCreateAttribute(TaskAttribute parent, String id) {
        if (parent.getAttribute(id) == null) {
            return parent.createAttribute(id);
        }
        return parent.getAttribute(id);
    }
}

