/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum MessageKind implements Enumerator
{
    COMPLETE_LITERAL(0, "complete", "complete"),
    LOST_LITERAL(1, "lost", "lost"),
    FOUND_LITERAL(2, "found", "found"),
    UNKNOWN_LITERAL(3, "unknown", "unknown");

    public static final int COMPLETE = 0;
    public static final int LOST = 1;
    public static final int FOUND = 2;
    public static final int UNKNOWN = 3;
    private static final MessageKind[] VALUES_ARRAY;
    public static final List<MessageKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new MessageKind[]{COMPLETE_LITERAL, LOST_LITERAL, FOUND_LITERAL, UNKNOWN_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static MessageKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            MessageKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static MessageKind get(int value) {
        switch (value) {
            case 0: {
                return COMPLETE_LITERAL;
            }
            case 1: {
                return LOST_LITERAL;
            }
            case 2: {
                return FOUND_LITERAL;
            }
            case 3: {
                return UNKNOWN_LITERAL;
            }
        }
        return null;
    }

    private MessageKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

