/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class LabelColumnComparator
extends ViewerComparator {
    private static final int ASCENDING = 1024;
    private static final int NONE = 0;
    private static final int DESCENDING = 128;
    private final TableColumn column;
    private final int columnIndex;
    private final TableViewer tv;
    private int direction;

    public LabelColumnComparator(TableViewer tableViewer, TableColumn column, int columnIndex) {
        super(null);
        this.tv = tableViewer;
        this.column = column;
        this.columnIndex = columnIndex;
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LabelColumnComparator.this.tv.getComparator() == LabelColumnComparator.this) {
                    if (LabelColumnComparator.this.direction == 1024) {
                        LabelColumnComparator.this.setDirection(128);
                    } else {
                        LabelColumnComparator.this.setDirection(0);
                    }
                } else {
                    LabelColumnComparator.this.setDirection(1024);
                }
            }
        });
    }

    private void setDirection(int newDirection) {
        this.direction = newDirection;
        Table table = this.column.getParent();
        table.setSortDirection(this.direction);
        if (this.direction == 0) {
            table.setSortColumn(null);
            this.tv.setComparator(null);
        } else {
            table.setSortColumn(this.column);
            if (this.tv.getComparator() == this) {
                this.tv.refresh();
            } else {
                this.tv.setComparator((ViewerComparator)this);
            }
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        ColumnLabelProvider labelProvider = (ColumnLabelProvider)this.tv.getLabelProvider(this.columnIndex);
        String label1 = labelProvider.getText(e1);
        String label2 = labelProvider.getText(e2);
        if (this.direction == 1024) {
            return label1.compareTo(label2);
        }
        return label2.compareTo(label1);
    }
}

