/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.folding;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.projection.IProjectionListener;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;

public abstract class AbstractFoldingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextViewerLifecycle {
    protected volatile @Nullable IDocument document;
    protected volatile @Nullable ProjectionAnnotationModel projectionAnnotationModel;
    protected volatile @Nullable ITextViewer textViewer;
    protected volatile @Nullable ProjectionViewer projectionViewer;
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    private final IProjectionListener projectionListener = new IProjectionListener(){

        public void projectionDisabled() {
            AbstractFoldingStrategy.this.projectionAnnotationModel = null;
        }

        public void projectionEnabled() {
            if (AbstractFoldingStrategy.this.projectionViewer != null) {
                AbstractFoldingStrategy.this.projectionAnnotationModel = AbstractFoldingStrategy.this.projectionViewer.getProjectionAnnotationModel();
            }
        }
    };

    protected boolean modifyAnnotations(Collection<? extends Annotation> deletions, Map<? extends Annotation, ? extends Position> additions, Collection<? extends Annotation> modifications) {
        ProjectionAnnotationModel projectionAnnotationModel = this.projectionAnnotationModel;
        if (projectionAnnotationModel == null || deletions.isEmpty() && additions.isEmpty() && modifications.isEmpty()) {
            return false;
        }
        projectionAnnotationModel.modifyAnnotations(deletions.isEmpty() ? EMPTY_ANNOTATIONS : (Annotation[])deletions.toArray(Annotation[]::new), additions, modifications.isEmpty() ? EMPTY_ANNOTATIONS : (Annotation[])modifications.toArray(Annotation[]::new));
        return true;
    }

    public void initialReconcile() {
        this.reconcile(null);
    }

    public void install(@Nullable ITextViewer textViewer) {
        if (this.projectionViewer != null) {
            this.projectionViewer.removeProjectionListener(this.projectionListener);
        }
        this.textViewer = textViewer;
        if (textViewer instanceof ProjectionViewer) {
            ProjectionViewer projViewer;
            this.projectionViewer = projViewer = (ProjectionViewer)textViewer;
            projViewer.addProjectionListener(this.projectionListener);
            this.projectionAnnotationModel = projViewer.getProjectionAnnotationModel();
        }
    }

    public abstract void reconcile(DirtyRegion var1, @Nullable IRegion var2);

    public void reconcile(@Nullable IRegion subRegion) {
        IDocument document = this.document;
        if (document == null) {
            return;
        }
        if (subRegion != null) {
            try {
                this.reconcile(new DirtyRegion(subRegion.getOffset(), subRegion.getLength(), "__insert", document.get(subRegion.getOffset(), subRegion.getLength())), subRegion);
                return;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.reconcile(new DirtyRegion(0, document.getLength(), "__insert", document.get()), null);
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
    }

    public void uninstall() {
        this.setDocument(null);
        if (this.projectionViewer != null) {
            this.projectionViewer.removeProjectionListener(this.projectionListener);
            this.projectionViewer = null;
        }
        this.projectionListener.projectionDisabled();
        this.textViewer = null;
    }
}

