/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.type.core.internal.impl;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.emf.type.core.IElementMatcher;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePlugin;
import org.eclipse.gmf.runtime.emf.type.core.internal.EMFTypePluginStatusCodes;
import org.eclipse.gmf.runtime.emf.type.core.internal.l10n.EMFTypeCoreMessages;

public class XMLExpressionMatcher
implements IElementMatcher {
    public static final String ECONTAINER_VARIABLE = "eContainer";
    private final String id;
    private final Expression xmlExpression;

    public XMLExpressionMatcher(IConfigurationElement config, String id) throws CoreException {
        this.id = id;
        try {
            this.xmlExpression = ExpressionConverter.getDefault().perform(config);
        }
        catch (CoreException e) {
            throw EMFTypePluginStatusCodes.getInitException(id, EMFTypeCoreMessages.element_reason_invalid_enablement_expression_WARN_, (Exception)((Object)e));
        }
    }

    @Override
    public boolean matches(EObject eObject) {
        try {
            EvaluationResult result;
            EvaluationContext evaluationContext = new EvaluationContext(null, (Object)eObject);
            EObject container = eObject.eContainer();
            if (container != null) {
                evaluationContext.addVariable(ECONTAINER_VARIABLE, (Object)container);
            }
            if ((result = this.xmlExpression.evaluate((IEvaluationContext)evaluationContext)) == EvaluationResult.TRUE) {
                return true;
            }
        }
        catch (CoreException e) {
            Log.error((Plugin)EMFTypePlugin.getPlugin(), (int)23, (String)EMFTypeCoreMessages.bind((String)EMFTypeCoreMessages.expression_evaluation_failure_ERROR_, (Object)this.id), (Throwable)e);
        }
        return false;
    }
}

