/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.ui.internal.logical.resolver;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.DiagnosticSupport;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResolutionContext;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.IResourceDependencyRemoteResolver;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.MonitorCallback;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RemoteMonitoredProxyCreationListener;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.RemoteResolveComputation;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.ResolutionUtil;
import org.eclipse.emf.compare.ide.ui.internal.logical.resolver.SynchronizedResourceSet;
import org.eclipse.emf.compare.ide.ui.internal.util.ThreadSafeProgressMonitor;
import org.eclipse.emf.compare.rcp.EMFCompareLogger;

public class ResourceDependencyRemoteResolver
implements IResourceDependencyRemoteResolver {
    private static final EMFCompareLogger LOGGER = new EMFCompareLogger(ResourceDependencyRemoteResolver.class);
    private final IResolutionContext context;

    public ResourceDependencyRemoteResolver(IResolutionContext context) {
        this.context = context;
    }

    @Override
    public void demandRemoteResolve(SynchronizedResourceSet resourceSet, URI uri, DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        if (ResolutionUtil.isInterruptedOrCanceled((IProgressMonitor)tspm)) {
            this.context.getScheduler().demandShutdown();
            return;
        }
        if (this.context.getScheduler().isScheduled(uri)) {
            return;
        }
        this.context.getScheduler().scheduleComputation(this.getRemoteResolveComputation(resourceSet, uri, diagnostic, tspm));
    }

    @Override
    public RemoteResolveComputation getRemoteResolveComputation(SynchronizedResourceSet resourceSet, URI uri, DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        return new RemoteResolveComputation(this.context, diagnostic, resourceSet, uri, new MonitorCallback(diagnostic, tspm), tspm);
    }

    @Override
    public SynchronizedResourceSet getResourceSetForRemoteResolution(DiagnosticSupport diagnostic, ThreadSafeProgressMonitor tspm) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("INSTANTIATING SynchronizedResourceSet for remote resolution.");
        }
        SynchronizedResourceSet resourceSet = new SynchronizedResourceSet(new RemoteMonitoredProxyCreationListener(tspm, this, diagnostic));
        return resourceSet;
    }
}

