/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.contentmodel.util;

import java.util.List;
import java.util.Vector;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceAttributeVisitor;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DOMNamespaceInfoManager {
    public static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";

    public List getNamespaceInfoList(Element element) {
        NamespaceInfoReader reader = new NamespaceInfoReader();
        return reader.getNamespaceInfoList(element);
    }

    public void removeNamespaceInfo(Element element) {
        NamespaceInfoRemover remover = new NamespaceInfoRemover();
        remover.removeNamespaceInfo(element);
    }

    public void addNamespaceInfo(Element element, List namespaceInfoList, boolean needsXSI) {
        Attr attr;
        Document document = element.getOwnerDocument();
        Object schemaLocationValue = "";
        for (NamespaceInfo nsInfo : namespaceInfoList) {
            nsInfo.normalize();
            if (nsInfo.uri != null) {
                String attrName = nsInfo.prefix != null ? "xmlns:" + nsInfo.prefix : "xmlns";
                Attr namespaceAttr = document.createAttribute(attrName);
                namespaceAttr.setValue(nsInfo.uri);
                element.setAttributeNode(namespaceAttr);
                if (nsInfo.locationHint != null) {
                    schemaLocationValue = (String)schemaLocationValue + nsInfo.uri;
                    schemaLocationValue = (String)schemaLocationValue + " ";
                    schemaLocationValue = (String)schemaLocationValue + nsInfo.locationHint;
                    schemaLocationValue = (String)schemaLocationValue + " ";
                }
                if (!nsInfo.uri.equals(XSI_URI)) continue;
                needsXSI = false;
                continue;
            }
            if (nsInfo.locationHint == null) continue;
            Attr attr2 = document.createAttribute("xsi:noNamespaceSchemaLocation");
            attr2.setValue(nsInfo.locationHint);
            element.setAttributeNode(attr2);
        }
        if (needsXSI) {
            attr = document.createAttribute("xmlns:xsi");
            attr.setValue(XSI_URI);
            element.setAttributeNode(attr);
        }
        if (((String)schemaLocationValue).length() > 0) {
            attr = document.createAttribute("xsi:schemaLocation");
            attr.setValue((String)schemaLocationValue);
            element.setAttributeNode(attr);
        }
    }

    protected static class NamespaceInfoReader
    extends NamespaceAttributeVisitor {
        protected List namespaceInfoList = new Vector();

        protected NamespaceInfoReader() {
        }

        public List getNamespaceInfoList(Element element) {
            this.visitElement(element);
            return this.namespaceInfoList;
        }

        @Override
        public void visitXSINoNamespaceSchemaLocationAttribute(Attr attr, String value) {
            NamespaceInfo info = this.createNamespaceInfo();
            info.locationHint = value;
        }

        @Override
        public void visitXMLNamespaceAttribute(Attr attr, String prefix, String uri) {
            NamespaceInfo info = this.createNamespaceInfo();
            info.uri = uri;
            info.prefix = prefix;
            super.visitXMLNamespaceAttribute(attr, prefix, uri);
        }

        @Override
        public void visitXSISchemaLocationValuePair(String uri, String locationHint) {
            NamespaceInfo info = this.getNamespaceInfoForURI(uri);
            if (info != null) {
                info.locationHint = locationHint;
            } else {
                info = this.createNamespaceInfo();
                info.uri = uri;
                info.locationHint = locationHint;
            }
        }

        protected NamespaceInfo getNamespaceInfoForURI(String uri) {
            NamespaceInfo result = null;
            for (NamespaceInfo info : this.namespaceInfoList) {
                if (info.uri == null || !info.uri.equals(uri)) continue;
                result = info;
                break;
            }
            return result;
        }

        protected NamespaceInfo createNamespaceInfo() {
            NamespaceInfo info = new NamespaceInfo();
            this.namespaceInfoList.add(info);
            return info;
        }
    }

    protected static class NamespaceInfoRemover
    extends NamespaceAttributeVisitor {
        protected List attributesToRemove = new Vector();

        protected NamespaceInfoRemover() {
        }

        public void removeNamespaceInfo(Element element) {
            this.visitElement(element);
            this.removeAttributes();
        }

        @Override
        public void visitXSINoNamespaceSchemaLocationAttribute(Attr attr, String value) {
            this.attributesToRemove.add(attr);
        }

        @Override
        public void visitXMLNamespaceAttribute(Attr attr, String namespacePrefix, String namespaceURI) {
            this.attributesToRemove.add(attr);
            super.visitXMLNamespaceAttribute(attr, namespacePrefix, namespaceURI);
        }

        @Override
        public void visitXSISchemaLocationAttribute(Attr attr, String value) {
            this.attributesToRemove.add(attr);
        }

        public void removeAttributes() {
            for (Attr attr : this.attributesToRemove) {
                Element element = attr.getOwnerElement();
                if (element == null) continue;
                element.removeAttributeNode(attr);
            }
        }
    }
}

