/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;

public class RenameResourceChange
extends ResourceChange {
    private final String fNewName;
    private final IPath fResourcePath;
    private final long fStampToRestore;
    private ChangeDescriptor fDescriptor;

    public RenameResourceChange(IPath resourcePath, String newName) {
        this(resourcePath, newName, -1L);
    }

    protected RenameResourceChange(IPath resourcePath, String newName, long stampToRestore) {
        if (resourcePath == null || newName == null || newName.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.fResourcePath = resourcePath;
        this.fNewName = newName;
        this.fStampToRestore = stampToRestore;
        this.fDescriptor = null;
        this.setValidationMethod(2);
    }

    @Override
    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }

    @Override
    protected IResource getModifiedResource() {
        return this.getResource();
    }

    @Override
    public String getName() {
        return Messages.format(RefactoringCoreMessages.RenameResourceChange_name, new String[]{BasicElementLabels.getPathLabel(this.fResourcePath, false), BasicElementLabels.getResourceName(this.fNewName)});
    }

    public String getNewName() {
        return this.fNewName;
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    @Override
    public Change perform(IProgressMonitor pm) throws CoreException {
        try {
            pm.beginTask(RefactoringCoreMessages.RenameResourceChange_progress_description, 1);
            IResource resource = this.getResource();
            long currentStamp = resource.getModificationStamp();
            IPath newPath = RenameResourceChange.renamedResourcePath(this.fResourcePath, this.fNewName);
            resource.move(newPath, 32, pm);
            if (this.fStampToRestore != -1L) {
                IResource newResource = ResourcesPlugin.getWorkspace().getRoot().findMember(newPath);
                newResource.revertModificationStamp(this.fStampToRestore);
            }
            String oldName = this.fResourcePath.lastSegment();
            RenameResourceChange renameResourceChange = new RenameResourceChange(newPath, oldName, currentStamp);
            return renameResourceChange;
        }
        finally {
            pm.done();
        }
    }

    private static IPath renamedResourcePath(IPath path, String newName) {
        return path.removeLastSegments(1).append(newName);
    }
}

