/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.search;

import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.ASTNodes;
import org.eclipse.php.core.ast.nodes.ArrayAccess;
import org.eclipse.php.core.ast.nodes.Assignment;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.ForEachStatement;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.Variable;
import org.eclipse.php.core.ast.nodes.VariableBase;
import org.eclipse.php.internal.core.CoreMessages;
import org.eclipse.php.internal.core.search.AbstractOccurrencesFinder;
import org.eclipse.php.internal.core.search.IOccurrencesFinder;
import org.eclipse.php.internal.core.search.Messages;

public class LocalVariableOccurrencesFinder
extends AbstractOccurrencesFinder {
    public static final String ID = "LocalVariableOccurrencesFinder";
    private Identifier fIdentifier;
    private FunctionDeclaration fFunctionDeclaration;

    @Override
    public String initialize(Program root, ASTNode node) {
        this.fASTRoot = root;
        if (this.isIdendifier(node)) {
            this.fIdentifier = (Identifier)node;
            ASTNode parent = node.getParent();
            while (parent != null && this.fFunctionDeclaration == null) {
                int type = parent.getType();
                if (type == 29) {
                    this.fFunctionDeclaration = (FunctionDeclaration)parent;
                }
                parent = parent.getParent();
            }
            return null;
        }
        this.fDescription = "OccurrencesFinder_occurrence_description";
        return this.fDescription;
    }

    private final boolean isIdendifier(ASTNode node) {
        return node != null && node.getType() == 33;
    }

    @Override
    protected void findOccurrences() {
        this.fDescription = Messages.format(CoreMessages.getString("LocalVariableOccurrencesFinder.1"), this.fIdentifier.getName());
        this.fFunctionDeclaration.accept(this);
    }

    @Override
    public boolean visit(Variable variable) {
        Expression name = variable.getName();
        if (name.getType() == 33 && (variable.isDollared() && variable.getParent().getType() != 52 || !variable.isDollared() && ASTNodes.isQuotedDollaredCurlied(variable)) && ((Identifier)name).getName().equals(this.fIdentifier.getName())) {
            this.addOccurrence(variable);
        }
        return true;
    }

    private void addOccurrence(ASTNode node) {
        int readWriteType = this.getOccurrenceType(node);
        String desc = this.fDescription;
        if (readWriteType == 1) {
            desc = Messages.format(BASE_WRITE_DESCRIPTION, "$" + this.fIdentifier.getName());
        }
        this.fResult.add(new IOccurrencesFinder.OccurrenceLocation(node.getStart(), node.getLength(), readWriteType, desc));
    }

    @Override
    protected int getOccurrenceType(ASTNode node) {
        Variable variable = (Variable)node;
        ASTNode parent = variable.getParent();
        boolean isArrayAccess = false;
        int parentType = parent.getType();
        if (parentType == 0) {
            parent = parent.getParent();
            parentType = parent.getType();
            isArrayAccess = true;
        }
        if (parentType == 3) {
            Assignment assignment = (Assignment)parent;
            VariableBase leftHandSide = assignment.getLeftHandSide();
            if (!isArrayAccess ? leftHandSide == node : leftHandSide.getType() == 0 && ((ArrayAccess)leftHandSide).getName() == node) {
                return 1;
            }
        }
        if (parentType == 26 && node.getLocationInParent() != ForEachStatement.EXPRESSION_PROPERTY || parentType == 27 || parentType == 9 || parentType == 45 || parentType == 48 && parent.getParent().getType() == 27 || parentType == 44) {
            return 1;
        }
        return 2;
    }

    @Override
    public String getElementName() {
        return this.fIdentifier.getName();
    }

    @Override
    public String getID() {
        return ID;
    }
}

