/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.midx.MultiPackIndexWriter;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.lib.ProgressMonitor;

public class DfsMidxWriter {
    private DfsMidxWriter() {
    }

    public static DfsPackDescription writeMidx(ProgressMonitor pm, DfsObjDatabase objdb, List<DfsPackFile> packs, @Nullable DfsPackDescription base) throws IOException {
        LinkedHashMap<String, PackIndex> inputs = new LinkedHashMap<String, PackIndex>(packs.size());
        Throwable throwable = null;
        Throwable throwable2 = null;
        try (DfsReader ctx = objdb.newReader();){
            for (DfsPackFile pack : packs) {
                inputs.put(pack.getPackDescription().getPackName(), pack.getPackIndex(ctx));
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        DfsPackDescription midxPackDesc = objdb.newPack(DfsObjDatabase.PackSource.GC);
        throwable2 = null;
        Object var7_10 = null;
        try (DfsOutputStream out = objdb.writeFile(midxPackDesc, PackExt.MULTI_PACK_INDEX);){
            MultiPackIndexWriter w = new MultiPackIndexWriter();
            MultiPackIndexWriter.Result result = w.write(pm, out, inputs);
            midxPackDesc.addFileExt(PackExt.MULTI_PACK_INDEX);
            midxPackDesc.setObjectCount(result.objectCount());
            Map byName = packs.stream().map(DfsPackFile::getPackDescription).collect(Collectors.toMap(DfsPackDescription::getPackName, Function.identity()));
            List coveredPacks = result.packNames().stream().map(byName::get).collect(Collectors.toList());
            midxPackDesc.setCoveredPacks(coveredPacks);
            if (base != null) {
                midxPackDesc.setMultiPackIndexBase(base);
            }
        }
        catch (Throwable throwable4) {
            if (throwable2 == null) {
                throwable2 = throwable4;
            } else if (throwable2 != throwable4) {
                throwable2.addSuppressed(throwable4);
            }
            throw throwable2;
        }
        return midxPackDesc;
    }
}

