/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.util;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSImportRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.util.AbstractCssTraverser;
import org.eclipse.wst.css.core.internal.util.CSSPathService;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.css.CSSValue;

public class CSSLinkConverter
extends AbstractCssTraverser {
    private static final String URL_BEGIN = "url(";
    private static final String URL_END = ")";
    private static final String EMPTY = "";
    private static final String D_QUOTE = "\"";
    private static final String S_QUOTE = "'";
    IStructuredModel baseModel;

    public CSSLinkConverter(IStructuredModel model) {
        this.baseModel = model;
        if (model instanceof ICSSModel && ((ICSSModel)model).getStyleSheetType() != "externalCSS") {
            IDOMNode node = (IDOMNode)((ICSSModel)model).getOwnerDOMNode();
            this.baseModel = node.getModel();
        }
    }

    public static String addFunc(String value) {
        if (!value.trim().toLowerCase().startsWith(URL_BEGIN)) {
            Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
            String quote = preferences.getString("quote");
            value = CSSUtil.stripQuotes(value);
            quote = CSSUtil.detectQuote(value, quote);
            String str = URL_BEGIN;
            if (preferences.getInt("propValueCase") == 2) {
                str = str.toUpperCase();
            }
            StringBuffer buf = new StringBuffer(str);
            buf.append(quote);
            buf.append(value);
            buf.append(quote);
            buf.append(URL_END);
            return buf.toString();
        }
        return value;
    }

    @Override
    protected void begin(ICSSNode node) {
        if (this.baseModel == null) {
            this.baseModel = node.getOwnerDocument().getModel();
            if (this.baseModel instanceof ICSSModel && ((ICSSModel)this.baseModel).getStyleSheetType() != "externalCSS") {
                IDOMNode xmlNode = (IDOMNode)((ICSSModel)this.baseModel).getOwnerDOMNode();
                this.baseModel = xmlNode.getModel();
            }
        }
    }

    private static boolean isUrl(String source) {
        if (source == null) {
            return false;
        }
        source = source.trim().toLowerCase();
        return source.startsWith(URL_BEGIN);
    }

    @Override
    protected short preNode(ICSSNode node) {
        if (node.getNodeType() == 11) {
            this.toAbsolute((CSSValue)((Object)node));
        } else if (node.getNodeType() == 3) {
            ICSSImportRule iRule = (ICSSImportRule)node;
            iRule.setHref(this.toAbsolute(CSSLinkConverter.addFunc(iRule.getHref())));
        }
        return TRAV_CONT;
    }

    public static String removeFunc(String value) {
        if (value == null) {
            return EMPTY;
        }
        String field = value.trim();
        if (field.toLowerCase().startsWith(URL_BEGIN)) {
            int url = field.toLowerCase().indexOf(URL_BEGIN);
            int endParenthesis = field.lastIndexOf(URL_END);
            field = endParenthesis > url ? field.substring(url + 4, endParenthesis) : field.substring(url + 4);
        }
        return field.trim();
    }

    public static String stripFunc(String value) {
        if (value == null) {
            return EMPTY;
        }
        String field = CSSLinkConverter.removeFunc(value);
        if (field.toLowerCase().startsWith(D_QUOTE)) {
            int quote = field.indexOf(D_QUOTE);
            int end = field.lastIndexOf(D_QUOTE);
            field = end > quote ? field.substring(quote + 1, end) : field.substring(quote + 1);
        } else if (field.toLowerCase().startsWith(S_QUOTE)) {
            int quote = field.indexOf(S_QUOTE);
            int end = field.lastIndexOf(S_QUOTE);
            field = end > quote ? field.substring(quote + 1, end) : field.substring(quote + 1);
        }
        return field.trim();
    }

    public String toAbsolute(String source) {
        if (CSSLinkConverter.isUrl(source)) {
            String url = CSSPathService.getAbsoluteURL(this.baseModel, CSSLinkConverter.stripFunc(source));
            return url != null ? CSSLinkConverter.addFunc(url) : "url()";
        }
        return source;
    }

    public boolean toAbsolute(CSSValue node) {
        ICSSPrimitiveValue value;
        if (node instanceof ICSSPrimitiveValue && (value = (ICSSPrimitiveValue)node).getPrimitiveType() == 20) {
            value.setValue(CSSLinkConverter.stripFunc(this.toAbsolute(URL_BEGIN + value.getStringValue() + URL_END)));
            return true;
        }
        return false;
    }
}

