/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.Collection;
import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class ForStatement
extends Statement {
    private final List<? extends Expression> initializations;
    private final List<? extends Expression> conditions;
    private final List<? extends Expression> increasements;
    private final Statement action;

    public ForStatement(int start, int end, List<? extends Expression> initializations, List<? extends Expression> conditions, List<? extends Expression> increasements, Statement action) {
        super(start, end);
        assert (initializations != null && conditions != null && increasements != null && action != null);
        this.initializations = initializations;
        this.conditions = conditions;
        this.increasements = increasements;
        this.action = action;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Statement)this)) {
            for (Expression expression : this.initializations) {
                expression.traverse(visitor);
            }
            for (Expression expression : this.conditions) {
                expression.traverse(visitor);
            }
            for (Expression expression : this.increasements) {
                expression.traverse(visitor);
            }
            this.action.traverse(visitor);
            visitor.endvisit((Statement)this);
        }
    }

    public int getKind() {
        return 28;
    }

    public Statement getAction() {
        return this.action;
    }

    public Collection<? extends Expression> getConditions() {
        return this.conditions;
    }

    public Collection<? extends Expression> getIncreasements() {
        return this.increasements;
    }

    public Collection<? extends Expression> getInitializations() {
        return this.initializations;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

