/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.taginfo;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.wst.sse.ui.internal.taginfo.AbstractHoverProcessor;

public class DebugInfoHoverProcessor
extends AbstractHoverProcessor {
    public static final String TRACEFILTER = "debuginfohover";
    protected IPreferenceStore fPreferenceStore = null;

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        String displayText = null;
        if (hoverRegion == null || viewer == null || viewer.getDocument() == null) {
            displayText = null;
        } else {
            int offset = hoverRegion.getOffset();
            try {
                ITypedRegion region = viewer.getDocument().getPartition(offset);
                displayText = region != null ? region.getType() : "Null Region was returned?!";
            }
            catch (BadLocationException badLocationException) {
                displayText = "BadLocationException Occurred!?";
            }
        }
        return displayText;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        ITypedRegion region = null;
        if (textViewer == null || textViewer.getDocument() == null) {
            region = null;
        } else {
            try {
                region = textViewer.getDocument().getPartition(offset);
            }
            catch (BadLocationException badLocationException) {
                region = null;
            }
        }
        return region;
    }
}

