/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.util;

import java.util.StringTokenizer;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.search.MethodNameMatch;
import org.eclipse.dltk.internal.ui.util.StringMatcher;
import org.eclipse.dltk.ui.IDLTKUILanguageToolkit;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class MethodFilter
implements IPropertyChangeListener {
    private IDLTKUILanguageToolkit fToolkit;
    private StringMatcher[] fStringMatchers;

    public MethodFilter(IDLTKUILanguageToolkit toolkit) {
        this.fToolkit = toolkit;
    }

    public boolean isFiltered(String fullMethodName) {
        return this.filter(fullMethodName);
    }

    public boolean isFiltered(char[] fullMethodName) {
        return this.filter(new String(fullMethodName));
    }

    protected String concatenate(char[] packageName, char[] MethodName) {
        return new String(packageName) + " " + new String(MethodName);
    }

    public boolean isFiltered(char[] packageName, char[] MethodName) {
        return this.filter(this.concatenate(packageName, MethodName));
    }

    public boolean isFiltered(IMethod method) {
        if (this.hasFilters()) {
            return this.filter(method.getFullyQualifiedName());
        }
        return false;
    }

    public boolean isFiltered(MethodNameMatch match) {
        return this.filter(match.getFullyQualifiedName());
    }

    protected IPreferenceStore getPreferenceStore() {
        return this.fToolkit.getPreferenceStore();
    }

    public MethodFilter() {
        this.fStringMatchers = null;
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private synchronized StringMatcher[] getStringMatchers() {
        if (this.fStringMatchers == null) {
            String str = this.getPreferenceStore().getString("org.eclipse.dltk.ui.methodfilter.enabled");
            StringTokenizer tok = new StringTokenizer(str, ";");
            int nTokens = tok.countTokens();
            this.fStringMatchers = new StringMatcher[nTokens];
            int i = 0;
            while (i < nTokens) {
                String curr = tok.nextToken();
                if (curr.length() > 0) {
                    this.fStringMatchers[i] = new StringMatcher(curr, false, false);
                }
                ++i;
            }
        }
        return this.fStringMatchers;
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.fStringMatchers = null;
    }

    public boolean hasFilters() {
        return this.getStringMatchers().length > 0;
    }

    public boolean filter(String fullMethodName) {
        StringMatcher[] matchers = this.getStringMatchers();
        int i = 0;
        while (i < matchers.length) {
            StringMatcher curr = matchers[i];
            if (curr.match(fullMethodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public synchronized void propertyChange(PropertyChangeEvent event) {
        if ("org.eclipse.dltk.ui.methodfilter.enabled".equals(event.getProperty())) {
            this.fStringMatchers = null;
        }
    }
}

