/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import java.util.SortedSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.commons.workbench.WorkbenchUtil;
import org.eclipse.mylyn.internal.tasks.ui.editors.Messages;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskEditorExtensions;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractTaskRepositoryPageContribution;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class TaskEditorExtensionSettingsContribution
extends AbstractTaskRepositoryPageContribution {
    private static final String LABEL_NONE = Messages.TaskEditorExtensionSettingsContribution_Plain_Text;
    private static final String LABEL_DEFAULT_SUFFIX = Messages.TaskEditorExtensionSettingsContribution__default_;
    private static final String DATA_EDITOR_EXTENSION = "editorExtension";
    private final SelectionListener listener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            TaskEditorExtensionSettingsContribution.this.selectedExtensionId = (String)((Widget)e.getSource()).getData(TaskEditorExtensionSettingsContribution.DATA_EDITOR_EXTENSION);
            TaskEditorExtensionSettingsContribution.this.fireValidationRequired();
        }
    };
    private String selectedExtensionId;
    private Button avatarSupportButton;

    public TaskEditorExtensionSettingsContribution() {
        super(Messages.TaskEditorExtensionSettingsContribution_Editor, Messages.TaskEditorExtensionSettingsContribution_Select_the_capabilities_of_the_task_editor);
    }

    @Override
    public void applyTo(TaskRepository repository) {
        TaskEditorExtensions.setTaskEditorExtensionId(repository, this.selectedExtensionId == null ? "none" : this.selectedExtensionId);
        repository.setProperty("avatarSupport", Boolean.toString(this.avatarSupportButton.getSelection()));
    }

    @Override
    public boolean canFlipToNextPage() {
        return true;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public Control createControl(Composite parentControl) {
        Composite parent = new Composite(parentControl, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        this.createGravatarControl(parent);
        Group group = new Group(parent, 0);
        group.setText(Messages.TaskEditorExtensionSettingsContribution_Rendering_Group_Label);
        group.setLayout((Layout)new GridLayout(1, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
        this.createTaskEditorExtensionsControl((Composite)group);
        return parent;
    }

    private void createGravatarControl(Composite parent) {
        this.avatarSupportButton = new Button(parent, 32);
        this.avatarSupportButton.setText(Messages.TaskEditorExtensionSettingsContribution_Avatar_Button_Label);
        this.avatarSupportButton.setSelection(this.getRepository() != null && Boolean.parseBoolean(this.getRepository().getProperty("avatarSupport")));
    }

    private void createTaskEditorExtensionsControl(Composite parent) {
        boolean isDefault;
        Composite infoComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(infoComposite);
        Label infoImage = new Label(infoComposite, 0);
        infoImage.setImage(CommonImages.getImage((ImageDescriptor)CommonImages.INFORMATION));
        Label infoLabel = new Label(infoComposite, 0);
        infoLabel.setText(Messages.TaskEditorExtensionSettingsContribution_Rendering_Group_Info);
        String defaultExtensionId = TaskEditorExtensions.getDefaultTaskEditorExtensionId(this.getConnectorKind());
        this.selectedExtensionId = this.getRepository() == null ? defaultExtensionId : TaskEditorExtensions.getTaskEditorExtensionId(this.getRepository());
        Button noneButton = new Button(parent, 16);
        Object noneTitle = LABEL_NONE;
        boolean bl = isDefault = defaultExtensionId == null || defaultExtensionId.length() == 0;
        if (isDefault) {
            noneTitle = (String)noneTitle + LABEL_DEFAULT_SUFFIX;
        }
        noneButton.setText((String)noneTitle);
        noneButton.addSelectionListener(this.listener);
        boolean foundSelection = false;
        SortedSet<TaskEditorExtensions.RegisteredTaskEditorExtension> allEditorExtensions = TaskEditorExtensions.getTaskEditorExtensions();
        for (TaskEditorExtensions.RegisteredTaskEditorExtension editorExtension : allEditorExtensions) {
            if (!WorkbenchUtil.allowUseOf((Object)editorExtension)) continue;
            Object name = editorExtension.getName();
            isDefault = editorExtension.getId().equals(defaultExtensionId);
            if (isDefault) {
                name = (String)name + LABEL_DEFAULT_SUFFIX;
            }
            Button button = new Button(parent, 16);
            button.setText((String)name);
            if (editorExtension.getId().equals(this.selectedExtensionId)) {
                foundSelection = true;
                button.setSelection(true);
            }
            button.setText((String)name);
            button.setData(DATA_EDITOR_EXTENSION, (Object)editorExtension.getId());
            button.addSelectionListener(this.listener);
        }
        if (!foundSelection) {
            noneButton.setSelection(true);
        }
    }

    @Override
    public IStatus validate() {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return !TaskEditorExtensions.getTaskEditorExtensions().isEmpty();
    }
}

