/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.grammar.rng;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.relaxng.utils.RelaxNGUtils;
import org.eclipse.lemminx.services.extensions.AbstractDefinitionParticipant;
import org.eclipse.lemminx.services.extensions.IDefinitionRequest;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class RNGDefinitionParticipant
extends AbstractDefinitionParticipant {
    @Override
    protected boolean match(DOMDocument document) {
        return DOMUtils.isRelaxNGXMLSyntax(document);
    }

    @Override
    protected void doFindDefinition(IDefinitionRequest request, List<LocationLink> locations, CancelChecker cancelChecker) {
        DOMNode node = request.getNode();
        if (!node.isAttribute()) {
            return;
        }
        DOMAttr attr = (DOMAttr)node;
        RelaxNGUtils.BindingType bindingType = RelaxNGUtils.getBindingType(attr);
        if (bindingType != RelaxNGUtils.BindingType.NONE) {
            RelaxNGUtils.searchRNGTargetAttributes(attr, bindingType, true, true, (targetNamespacePrefix, targetAttr) -> {
                LocationLink location = XMLPositionUtility.createLocationLink(attr.getNodeAttrValue(), targetAttr.getNodeAttrValue());
                locations.add(location);
            });
        }
    }
}

