/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDConstants;
import org.eclipse.xsd.util.XSDResourceImpl;

public abstract class XSDSchemaQueryTools {
    public static List<XSDTypeDefinition> findTypesDerivedFrom(XSDSchema schema, String namespace, String localName) {
        if (schema == null || localName == null) {
            throw new IllegalArgumentException("findTypesDerivedFrom called with null schema/localName");
        }
        ArrayList<XSDTypeDefinition> typesDerivedFrom = new ArrayList<XSDTypeDefinition>();
        EList<XSDTypeDefinition> typedefs = schema.getTypeDefinitions();
        for (XSDTypeDefinition typedef : typedefs) {
            if (!XSDSchemaQueryTools.isTypeDerivedFrom(typedef, namespace, localName)) continue;
            typesDerivedFrom.add(typedef);
        }
        return typesDerivedFrom;
    }

    @Deprecated
    public static boolean isTypeDerivedFrom(XSDTypeDefinition typedef, String namespace, String localName) {
        return XSDConstants.isOrIsDerivedFrom(typedef, localName, namespace);
    }

    public static List<XSDElementDeclaration> findElementsUsingType(XSDSchema schema, String namespace, String localName) {
        if (schema == null || localName == null) {
            throw new IllegalArgumentException("findElementsUsingType called with null schema/localName");
        }
        ArrayList<XSDElementDeclaration> elemsUsingType = new ArrayList<XSDElementDeclaration>();
        EList<XSDElementDeclaration> elemDecls = schema.getElementDeclarations();
        for (XSDElementDeclaration elem : elemDecls) {
            XSDTypeDefinition typedef = null;
            if (elem.getAnonymousTypeDefinition() != null) {
                typedef = elem.getAnonymousTypeDefinition();
            } else {
                if (elem.getTypeDefinition() == null) continue;
                typedef = elem.getTypeDefinition();
            }
            if (!typedef.hasNameAndTargetNamespace(localName, namespace) && !XSDSchemaQueryTools.isTypeDerivedFrom(typedef, namespace, localName)) continue;
            elemsUsingType.add(elem);
        }
        return elemsUsingType;
    }

    public static HashMap<String, String> hasImpInclRedef(XSDSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("hasImpInclRedef called with null schema");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        XSDSchemaQueryTools.mapImpInclRedef(schema, hash, 0);
        if (hash.size() == 0) {
            return null;
        }
        return hash;
    }

    public static HashMap<String, String> hasImpInclRedef2(XSDSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException("hasImpInclRedef2 called with null schema");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        Resource currentResource = schema.eResource();
        ResourceSet resourceSet = currentResource.getResourceSet();
        for (Resource resource : resourceSet.getResources()) {
            if (!(resource instanceof XSDResourceImpl)) continue;
            XSDResourceImpl xsdResource = (XSDResourceImpl)resource;
            XSDSchema otherSchema = xsdResource.getSchema();
            for (XSDSchemaContent content : otherSchema.getContents()) {
                if (!(content instanceof XSDSchemaDirective)) continue;
                XSDSchemaDirective schemaDirective = (XSDSchemaDirective)content;
                String type = null;
                type = content instanceof XSDImport ? "XSDImport" : (content instanceof XSDInclude ? "XSDInclude" : (content instanceof XSDRedefine ? "XSDRedefine" : "unknown"));
                if (schemaDirective.getResolvedSchema() == null) {
                    type = String.valueOf(type) + "-unresolved";
                }
                hash.put(schemaDirective.getSchemaLocation(), type);
                XSDSchema nextSchema = schemaDirective.getResolvedSchema();
                if (nextSchema == null) continue;
                XSDSchemaQueryTools.mapImpInclRedef(nextSchema, hash, 1);
            }
        }
        if (hash.size() == 0) {
            return null;
        }
        return hash;
    }

    protected static void mapImpInclRedef(XSDSchema schema, HashMap<String, String> hash, int level) {
        for (XSDSchemaContent schemaContent : schema.getContents()) {
            if (!(schemaContent instanceof XSDSchemaDirective)) continue;
            XSDSchemaDirective schemaDirective = (XSDSchemaDirective)schemaContent;
            String type = null;
            type = schemaContent instanceof XSDImport ? "XSDImport-level" + level : (schemaContent instanceof XSDInclude ? "XSDInclude-level" + level : (schemaContent instanceof XSDRedefine ? "XSDRedefine-level" + level : "unknown-level" + level));
            if (schemaDirective.getResolvedSchema() == null) {
                type = String.valueOf(type) + "-unresolved";
            }
            hash.put(schemaDirective.getSchemaLocation(), type);
            XSDSchema nextSchema = schemaDirective.getResolvedSchema();
            if (nextSchema == null) continue;
            XSDSchemaQueryTools.mapImpInclRedef(nextSchema, hash, level + 1);
        }
    }
}

