/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.ui.internal.taskwizard;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.ui.Messages;
import org.eclipse.wst.common.componentcore.ui.Trace;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.TaskWizardPage;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WizardFragment;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.WorkspaceRunnableAdapter;

public class TaskWizard
implements IWizard {
    private static final byte FINISH = 2;
    private static final byte CANCEL = 3;
    private List<IWizardPage> pages;
    private boolean addingPages;
    private Map<WizardFragment, TaskWizardPage> fragmentData = new HashMap<WizardFragment, TaskWizardPage>();
    protected TaskModel taskModel;
    private IWizardContainer container = null;
    private boolean needsProgressMonitor = false;
    private boolean forcePreviousAndNextButtons = false;
    private boolean isHelpAvailable = false;
    private Image defaultImage = null;
    private RGB titleBarColor = null;
    private String windowTitle = null;
    private IDialogSettings dialogSettings = null;
    private WizardFragment rootFragment;
    private WizardFragment currentFragment;
    private Object finishFamily;

    public TaskWizard(String title, WizardFragment rootFragment) {
        this(title, rootFragment, null);
        this.setWindowTitle(title);
    }

    public TaskWizard(String title, WizardFragment rootFragment, TaskModel taskModel) {
        if (title != null) {
            this.setWindowTitle(title);
        }
        this.rootFragment = rootFragment;
        this.taskModel = taskModel;
        if (taskModel == null) {
            this.taskModel = new TaskModel();
        }
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
    }

    public void setTaskModel(TaskModel taskModel) {
        this.taskModel = taskModel;
    }

    public TaskModel getTaskModel() {
        return this.taskModel;
    }

    public void setRootFragment(WizardFragment rootFragment) {
        this.rootFragment = rootFragment;
    }

    public WizardFragment getRootFragment() {
        return this.rootFragment;
    }

    public boolean performCancel() {
        final List<WizardFragment> list = this.getAllWizardFragments();
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TaskWizard.this.executeTask((WizardFragment)iterator.next(), (byte)3, monitor);
                    }
                }
                catch (CoreException ce) {
                    throw new InvocationTargetException(ce);
                }
            }
        };
        Throwable t = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, runnable);
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException te) {
            t = te.getCause();
        }
        catch (Exception e) {
            t = e;
        }
        Trace.trace((byte)3, "Error cancelling task wizard", t);
        this.handleThrowable(t);
        return false;
    }

    public boolean performFinish() {
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        final WizardFragment cFragment = this.currentFragment;
        final List<WizardFragment> list = this.getAllWizardFragments();
        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                int index = list.indexOf(cFragment);
                while (index > 0 && index < list.size() - 1) {
                    final WizardFragment fragment = (WizardFragment)list.get(++index);
                    try {
                        Display.getDefault().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                fragment.enter();
                                fragment.exit();
                            }
                        });
                    }
                    catch (Exception e) {
                        Trace.trace((byte)2, "Could not enter/exit page", e);
                    }
                }
                if (TaskWizard.this.useJob()) {
                    class FinishWizardJob
                    extends Job {
                        private final /* synthetic */ List val$list;

                        public FinishWizardJob(List list) {
                            this.val$list = list;
                            super(TaskWizard.this.getJobTitle());
                        }

                        public boolean belongsTo(Object family) {
                            return TaskWizard.this.getFinishJobFamily() == null && family == null || TaskWizard.this.getFinishJobFamily() != null && TaskWizard.this.getFinishJobFamily().equals(family);
                        }

                        public IStatus run(IProgressMonitor monitor2) {
                            try {
                                Iterator iterator = this.val$list.iterator();
                                while (iterator.hasNext()) {
                                    TaskWizard.this.executeTask((WizardFragment)iterator.next(), (byte)2, monitor2);
                                }
                            }
                            catch (CoreException ce) {
                                Trace.trace((byte)3, "Error finishing wizard job", ce);
                                return new Status(4, "org.eclipse.wst.common.modulecore.ui", 0, ce.getLocalizedMessage(), null);
                            }
                            return Status.OK_STATUS;
                        }
                    }
                    FinishWizardJob job = new FinishWizardJob(list);
                    job.setUser(true);
                    job.schedule();
                } else {
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TaskWizard.this.executeTask((WizardFragment)iterator.next(), (byte)2, monitor);
                    }
                }
            }
        };
        Throwable t = null;
        try {
            if (this.getContainer() != null) {
                this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceRunnableAdapter(runnable));
            } else {
                runnable.run((IProgressMonitor)new NullProgressMonitor());
            }
            return true;
        }
        catch (InvocationTargetException te) {
            Trace.trace((byte)3, "Error finishing task wizard", te);
            t = te.getCause();
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error finishing task wizard 2", e);
            t = e;
        }
        Trace.trace((byte)2, "Error completing wizard", t);
        this.handleThrowable(t);
        return false;
    }

    public Object getFinishJobFamily() {
        return this.finishFamily;
    }

    public void setFinishJobFamily(Object o) {
        this.finishFamily = o;
    }

    public void addPage(IWizardPage page) {
        this.pages.add(page);
        page.setWizard((IWizard)this);
    }

    protected void executeTask(WizardFragment fragment, byte type, IProgressMonitor monitor) throws CoreException {
        if (fragment == null) {
            return;
        }
        if (type == 2) {
            fragment.performFinish(monitor);
        } else if (type == 3) {
            fragment.performCancel(monitor);
        }
    }

    protected WizardFragment getCurrentWizardFragment() {
        return this.currentFragment;
    }

    protected void switchWizardFragment(WizardFragment newFragment) {
        int newIndex;
        List<WizardFragment> list = this.getAllWizardFragments();
        int oldIndex = list.indexOf(this.currentFragment);
        if (oldIndex == (newIndex = list.indexOf(newFragment))) {
            return;
        }
        if (this.currentFragment != null) {
            this.currentFragment.exit();
        }
        oldIndex = oldIndex < newIndex ? ++oldIndex : --oldIndex;
        while (oldIndex != newIndex) {
            WizardFragment fragment = list.get(oldIndex);
            fragment.enter();
            fragment.exit();
            if (oldIndex < newIndex) {
                ++oldIndex;
                continue;
            }
            --oldIndex;
        }
        this.currentFragment = newFragment;
        this.currentFragment.enter();
    }

    private List<WizardFragment> getAllWizardFragments() {
        ArrayList<WizardFragment> list = new ArrayList<WizardFragment>();
        list.add(this.rootFragment);
        this.addSubWizardFragments(this.rootFragment, list);
        for (WizardFragment fragment : list) {
            if (this.taskModel.equals(fragment.getTaskModel())) continue;
            fragment.setTaskModel(this.taskModel);
        }
        return list;
    }

    private void addSubWizardFragments(WizardFragment fragment, List<WizardFragment> list) {
        for (WizardFragment child : fragment.getChildFragments()) {
            list.add(child);
            this.addSubWizardFragments(child, list);
        }
    }

    public void addPages() {
        if (this.addingPages) {
            return;
        }
        try {
            try {
                this.addingPages = true;
                this.pages = new ArrayList<IWizardPage>();
                for (WizardFragment fragment : this.getAllWizardFragments()) {
                    TaskWizardPage page = this.getFragmentData(fragment);
                    if (!fragment.hasComposite()) continue;
                    if (page != null) {
                        this.addPage((IWizardPage)page);
                        continue;
                    }
                    TaskWizardPage page2 = new TaskWizardPage(fragment);
                    this.fragmentData.put(fragment, page2);
                    this.addPage((IWizardPage)page2);
                }
            }
            catch (Exception e) {
                Trace.trace((byte)3, "Error adding fragments to wizard", e);
                this.addingPages = false;
            }
        }
        finally {
            this.addingPages = false;
        }
    }

    private TaskWizardPage getFragmentData(WizardFragment fragment) {
        try {
            TaskWizardPage page = this.fragmentData.get(fragment);
            if (page != null) {
                return page;
            }
        }
        catch (Exception e) {
            Trace.trace((byte)3, "Error getting fragment data", e);
        }
        return null;
    }

    protected void updatePages() {
        this.addPages();
    }

    public boolean canFinish() {
        int i = 0;
        while (i < this.pages.size()) {
            if (!this.pages.get(i).isPageComplete()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void createPageControls(Composite pageContainer) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            page.createControl(pageContainer);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.pages.size()) {
            this.pages.get(i).dispose();
            ++i;
        }
        if (this.defaultImage != null) {
            this.defaultImage.dispose();
            this.defaultImage = null;
        }
    }

    public IWizardContainer getContainer() {
        return this.container;
    }

    public Image getDefaultPageImage() {
        return this.defaultImage;
    }

    public IDialogSettings getDialogSettings() {
        return this.dialogSettings;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == this.pages.size() - 1 || index == -1) {
            return null;
        }
        return this.pages.get(index + 1);
    }

    public IWizardPage getPage(String name) {
        int i = 0;
        while (i < this.pages.size()) {
            IWizardPage page = this.pages.get(i);
            String pageName = page.getName();
            if (pageName.equals(name)) {
                return page;
            }
            ++i;
        }
        return null;
    }

    public int getPageCount() {
        return this.pages.size();
    }

    public IWizardPage[] getPages() {
        return this.pages.toArray(new IWizardPage[this.pages.size()]);
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int index = this.pages.indexOf(page);
        if (index == 0 || index == -1) {
            return null;
        }
        return this.pages.get(index - 1);
    }

    public IWizardPage getStartingPage() {
        if (this.pages.size() == 0) {
            return null;
        }
        return this.pages.get(0);
    }

    public RGB getTitleBarColor() {
        return this.titleBarColor;
    }

    public String getWindowTitle() {
        return this.windowTitle;
    }

    public boolean isHelpAvailable() {
        return this.isHelpAvailable;
    }

    public boolean needsPreviousAndNextButtons() {
        return this.forcePreviousAndNextButtons || this.pages.size() > 1;
    }

    public boolean needsProgressMonitor() {
        return this.needsProgressMonitor;
    }

    public void setContainer(IWizardContainer wizardContainer) {
        this.container = wizardContainer;
    }

    public void setDialogSettings(IDialogSettings settings) {
        this.dialogSettings = settings;
    }

    public void setNeedsProgressMonitor(boolean b) {
        this.needsProgressMonitor = b;
    }

    public void setForcePreviousAndNextButtons(boolean b) {
        this.forcePreviousAndNextButtons = b;
    }

    public void setWindowTitle(String title) {
        this.windowTitle = title;
    }

    protected boolean useJob() {
        return false;
    }

    protected String getJobTitle() {
        return this.getWindowTitle();
    }

    private void handleThrowable(Throwable t) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final Shell shell = display.getActiveShell();
        final String message = t.getLocalizedMessage();
        final IStatus status = t instanceof CoreException ? ((CoreException)t).getStatus() : null;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (status == null) {
                    MessageDialog.openError((Shell)shell, (String)Messages.WizardError, (String)message);
                } else {
                    ErrorDialog.openError((Shell)shell, (String)Messages.WizardError, (String)message, (IStatus)status);
                }
            }
        });
    }
}

