/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal.wsdl11.xsd;

import java.util.ArrayList;
import java.util.List;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xni.parser.XMLParseException;
import org.eclipse.wst.wsdl.validation.internal.util.ErrorMessage;

public class ValidateErrorHandler
implements XMLErrorHandler {
    ArrayList errorList = new ArrayList();

    public List getErrorMessages() {
        return this.errorList;
    }

    protected ErrorMessage createValidationMessageForException(String key, XMLParseException error, int severity) {
        String uri = error.getLiteralSystemId();
        if (uri == null) {
            uri = error.getPublicId();
        }
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorLine(error.getLineNumber());
        errorMessage.setErrorMessage(error.getMessage());
        errorMessage.setErrorColumn(error.getColumnNumber());
        errorMessage.setURI(uri);
        errorMessage.setSeverity(severity);
        return errorMessage;
    }

    public void error(String domain, String key, XMLParseException exception) throws XNIException {
        this.errorList.add(this.createValidationMessageForException(key, exception, 2));
    }

    public void fatalError(String domain, String key, XMLParseException exception) throws XNIException {
        this.errorList.add(this.createValidationMessageForException(key, exception, 3));
    }

    public void warning(String domain, String key, XMLParseException exception) throws XNIException {
        this.errorList.add(this.createValidationMessageForException(key, exception, 1));
    }
}

