/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.catalog.io.xpp3;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.catalog.ArchetypeCatalog;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

public class ArchetypeCatalogXpp3Writer {
    private static final String NAMESPACE = null;
    private String fileComment = null;

    public void setFileComment(String fileComment) {
        this.fileComment = fileComment;
    }

    public void write(Writer writer, ArchetypeCatalog archetypeCatalog) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(writer);
        serializer.startDocument(archetypeCatalog.getModelEncoding(), null);
        this.writeArchetypeCatalog(archetypeCatalog, "archetype-catalog", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    public void write(OutputStream stream, ArchetypeCatalog archetypeCatalog) throws IOException {
        MXSerializer serializer = new MXSerializer();
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", (Object)"  ");
        serializer.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", (Object)"\n");
        serializer.setOutput(stream, archetypeCatalog.getModelEncoding());
        serializer.startDocument(archetypeCatalog.getModelEncoding(), null);
        this.writeArchetypeCatalog(archetypeCatalog, "archetype-catalog", (XmlSerializer)serializer);
        serializer.endDocument();
    }

    private void writeArchetype(Archetype archetype, String tagName, XmlSerializer serializer) throws IOException {
        serializer.startTag(NAMESPACE, tagName);
        if (archetype.getGroupId() != null) {
            serializer.startTag(NAMESPACE, "groupId").text(archetype.getGroupId()).endTag(NAMESPACE, "groupId");
        }
        if (archetype.getArtifactId() != null) {
            serializer.startTag(NAMESPACE, "artifactId").text(archetype.getArtifactId()).endTag(NAMESPACE, "artifactId");
        }
        if (archetype.getVersion() != null) {
            serializer.startTag(NAMESPACE, "version").text(archetype.getVersion()).endTag(NAMESPACE, "version");
        }
        if (archetype.getRepository() != null) {
            serializer.startTag(NAMESPACE, "repository").text(archetype.getRepository()).endTag(NAMESPACE, "repository");
        }
        if (archetype.getDescription() != null) {
            serializer.startTag(NAMESPACE, "description").text(archetype.getDescription()).endTag(NAMESPACE, "description");
        }
        serializer.endTag(NAMESPACE, tagName);
    }

    private void writeArchetypeCatalog(ArchetypeCatalog archetypeCatalog, String tagName, XmlSerializer serializer) throws IOException {
        if (this.fileComment != null) {
            serializer.comment(this.fileComment);
        }
        serializer.setPrefix("", "http://maven.apache.org/plugins/maven-archetype-plugin/archetype-catalog/1.0.0");
        serializer.setPrefix("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        serializer.startTag(NAMESPACE, tagName);
        serializer.attribute("", "xsi:schemaLocation", "http://maven.apache.org/plugins/maven-archetype-plugin/archetype-catalog/1.0.0 http://maven.apache.org/xsd/archetype-catalog-1.0.0.xsd");
        if (archetypeCatalog.getArchetypes() != null && archetypeCatalog.getArchetypes().size() > 0) {
            serializer.startTag(NAMESPACE, "archetypes");
            for (Archetype o : archetypeCatalog.getArchetypes()) {
                this.writeArchetype(o, "archetype", serializer);
            }
            serializer.endTag(NAMESPACE, "archetypes");
        }
        serializer.endTag(NAMESPACE, tagName);
    }
}

