/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.swt;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledPageBook;
import org.eclipse.ui.internal.intro.impl.model.IntroLink;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.swt.PageForm;
import org.eclipse.ui.internal.intro.impl.swt.PageStyleManager;
import org.eclipse.ui.internal.intro.impl.swt.SharedStyleManager;

public class PageFormWithNavigation
extends PageForm {
    private PageStyleManager rootPageStyleManager;
    public static String PAGE_FORM_WITH_NAVIGATION_ID = "pageFormWithNavigationId";

    public PageFormWithNavigation(FormToolkit toolkit, IntroModelRoot modelRoot, Form parentForm) {
        super(toolkit, modelRoot, parentForm);
    }

    @Override
    public void createPartControl(ScrolledPageBook mainPageBook, SharedStyleManager sharedStyleManager) {
        super.createPartControl(mainPageBook, sharedStyleManager);
        this.rootPageStyleManager = new PageStyleManager(this.model.getHomePage(), sharedStyleManager.getProperties());
        Composite navigationComposite = this.toolkit.createComposite(this.pageForm.getBody());
        navigationComposite.setLayoutData((Object)new GridData(64));
        int numberOfLinks = this.model.getRootPage().getLinks().length;
        GridLayout layout = new GridLayout();
        layout.numColumns = numberOfLinks;
        navigationComposite.setLayout((Layout)layout);
        this.createSmallNavigator(navigationComposite, this.model.getRootPage().getLinks());
        this.pageForm.setText(this.rootPageStyleManager.getPageSubTitle());
    }

    @Override
    protected String getId() {
        return PAGE_FORM_WITH_NAVIGATION_ID;
    }

    private void createSmallNavigator(Composite parent, IntroLink[] links) {
        int i = 0;
        while (i < links.length) {
            Control c = this.createImageHyperlink(parent, links[i]);
            c.setLayoutData((Object)new GridData(64));
            ++i;
        }
        i = 0;
        while (i < links.length) {
            Label text = this.toolkit.createLabel(parent, links[i].getLabel());
            text.setLayoutData((Object)new GridData(64));
            text.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            ++i;
        }
    }

    private Control createImageHyperlink(Composite body, IntroLink link) {
        ImageHyperlink imageLink = this.toolkit.createImageHyperlink(body, 0);
        Image image = this.rootPageStyleManager.getImage(link, "small-link-icon", "rootLinkSmall");
        imageLink.setImage(image);
        image = this.rootPageStyleManager.getImage(link, "small-hover-icon", null);
        imageLink.setHoverImage(image);
        imageLink.setToolTipText(link.getLabel());
        GridData gd = new GridData(64);
        imageLink.setLayoutData((Object)gd);
        imageLink.setHref((Object)link.getUrl());
        imageLink.addHyperlinkListener((IHyperlinkListener)this.hyperlinkAdapter);
        return imageLink;
    }
}

