/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.widgetmap;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.scout.sdk.core.typescript.builder.imports.ES6ImportValidator;
import org.eclipse.scout.sdk.core.util.Strings;

public abstract class Type {
    private static final Pattern NOT_ALLOWED_CLASS_NAME_CHARS = Pattern.compile("\\W");
    private String m_newClassName;
    private final Collection<String> m_usedNames;

    protected Type(CharSequence newClassName, Collection<String> usedNames) {
        this.m_usedNames = usedNames != null ? usedNames : new HashSet();
        this.m_newClassName = Type.ensureValidName(newClassName, this.usedNames());
    }

    protected Type(Collection<String> usedNames) {
        this(null, usedNames);
    }

    public Optional<String> newClassName() {
        return Optional.ofNullable(this.m_newClassName);
    }

    public Type withNewClassName(CharSequence name) {
        this.newClassName().ifPresent(this.usedNames()::remove);
        this.m_newClassName = Type.ensureValidName(name, this.usedNames());
        this.newClassName().ifPresent(this.usedNames()::add);
        return this;
    }

    public static String ensureValidName(CharSequence name, Collection<String> usedNames) {
        String candidate = Type.ensureValidName(name);
        if (candidate == null || !usedNames.contains(candidate)) {
            return candidate;
        }
        return ES6ImportValidator.getUniqueAlias((String)candidate, usedNames);
    }

    public static String ensureValidName(CharSequence name) {
        if (name == null) {
            return null;
        }
        return Strings.capitalize((CharSequence)NOT_ALLOWED_CLASS_NAME_CHARS.matcher(name).replaceAll("")).toString();
    }

    protected Collection<String> usedNames() {
        return this.m_usedNames;
    }
}

