/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.model.api;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IMethodParameter;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class PropertyBean {
    public static final String GETTER_PREFIX = "get";
    public static final String SETTER_PREFIX = "set";
    public static final String GETTER_BOOL_PREFIX = "is";
    public static final String CHAINED_SETTER_PREFIX = "with";
    public static final Pattern BEAN_METHOD_NAME = Pattern.compile("(get|set|is)([A-Z]\\w*)");
    public static final Pattern GETTER_METHOD_NAME = Pattern.compile("(get|is)([A-Z]\\w*)");
    public static final Pattern SETTER_METHOD_NAME = Pattern.compile("(set)([A-Z]\\w*)");
    private final String m_beanName;
    private final IType m_declaringType;
    private final FinalValue<IMethod> m_readMethod;
    private final FinalValue<IMethod> m_writeMethod;

    protected PropertyBean(IType declaringType, String beanName) {
        this.m_declaringType = (IType)Ensure.notNull((Object)declaringType);
        this.m_beanName = (String)Ensure.notNull((Object)beanName);
        this.m_readMethod = new FinalValue();
        this.m_writeMethod = new FinalValue();
    }

    public static Stream<PropertyBean> of(IType type) {
        List methods = type.methods().withFlags(1).stream().toList();
        HashMap<String, PropertyBean> beans = new HashMap<String, PropertyBean>();
        for (IMethod m : methods) {
            Optional<String> getterName = PropertyBean.getterName(m);
            if (getterName.isPresent()) {
                beans.computeIfAbsent(getterName.orElseThrow(), key -> new PropertyBean(type, (String)key)).setReadMethodIfAbsent(m);
                continue;
            }
            PropertyBean.setterName(m).ifPresent(name -> beans.computeIfAbsent((String)name, key -> new PropertyBean(type, (String)key)).setWriteMethodIfAbsent(m));
        }
        return beans.values().stream();
    }

    public static String getterPrefixFor(CharSequence returnType) {
        if (Strings.equals((CharSequence)"boolean", (CharSequence)returnType)) {
            return GETTER_BOOL_PREFIX;
        }
        return GETTER_PREFIX;
    }

    public static Optional<String> getterName(IMethodGenerator<?, ?> m, IJavaBuilderContext context) {
        return PropertyBean.propertyNameOf(m, false, context);
    }

    public static Optional<String> getterName(IMethod m) {
        return PropertyBean.propertyNameOf(m, false);
    }

    protected static Optional<String> getterName(CharSequence methodName, int numParams, String returnType) {
        boolean isBool;
        if (numParams != 0) {
            return Optional.empty();
        }
        if ("void".equals(returnType)) {
            return Optional.empty();
        }
        Matcher matcher = GETTER_METHOD_NAME.matcher(methodName);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String kind = matcher.group(1);
        String name = matcher.group(2);
        if (GETTER_PREFIX.equals(kind)) {
            return Optional.of(name);
        }
        boolean bl = isBool = "boolean".equals(returnType) || "java.lang.Boolean".equals(returnType);
        if (isBool && GETTER_BOOL_PREFIX.equals(kind)) {
            return Optional.of(name);
        }
        return Optional.empty();
    }

    public static Optional<String> setterName(IMethodGenerator<?, ?> m, IJavaBuilderContext context) {
        return PropertyBean.propertyNameOf(m, true, context);
    }

    public static Optional<String> setterName(IMethod m) {
        return PropertyBean.propertyNameOf(m, true);
    }

    protected static Optional<String> setterName(CharSequence methodName, int numParams, String returnType) {
        if (numParams != 1) {
            return Optional.empty();
        }
        if (!"void".equals(returnType)) {
            return Optional.empty();
        }
        Matcher matcher = SETTER_METHOD_NAME.matcher(methodName);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        return Optional.of(matcher.group(2));
    }

    protected static Optional<String> propertyNameOf(IMethodGenerator<?, ?> m, boolean setter, IJavaBuilderContext context) {
        Optional<String> returnType = m.returnType(context);
        if (returnType.isEmpty()) {
            return Optional.empty();
        }
        CharSequence methodName = m.elementName(context).orElseThrow(() -> Ensure.newFail((CharSequence)"Method name is missing.", (Object[])new Object[0]));
        int numParams = (int)m.parameters().count();
        if (setter) {
            return PropertyBean.setterName(methodName, numParams, returnType.orElseThrow());
        }
        return PropertyBean.getterName(methodName, numParams, returnType.orElseThrow());
    }

    protected static Optional<String> propertyNameOf(IMethod m, boolean setter) {
        Optional<IType> returnType = m.returnType();
        if (returnType.isEmpty()) {
            return Optional.empty();
        }
        int numParams = m.parameters().count();
        String returnDataType = returnType.orElseThrow().name();
        if (setter) {
            return PropertyBean.setterName(m.elementName(), numParams, returnDataType);
        }
        return PropertyBean.getterName(m.elementName(), numParams, returnDataType);
    }

    public static Optional<IType> dataTypeOf(IMethod getterOrSetter) {
        if (getterOrSetter == null) {
            return Optional.empty();
        }
        if (getterOrSetter.parameters().existsAny()) {
            return getterOrSetter.parameters().first().map(IMethodParameter::dataType);
        }
        return getterOrSetter.returnType().filter(t -> !t.isVoid());
    }

    public IType declaringType() {
        return this.m_declaringType;
    }

    public String name() {
        return this.m_beanName;
    }

    public IType type() {
        return this.readMethod().flatMap(IMethod::returnType).orElseGet(() -> this.writeMethod().map(writeMethod -> ((IMethodParameter)writeMethod.parameters().first().orElseThrow()).dataType()).orElseThrow());
    }

    public Optional<IMethod> readMethod() {
        return this.m_readMethod.opt();
    }

    public Optional<IMethod> writeMethod() {
        return this.m_writeMethod.opt();
    }

    protected void setReadMethodIfAbsent(IMethod readMethod) {
        this.m_readMethod.setIfAbsent((Object)readMethod);
    }

    protected void setWriteMethodIfAbsent(IMethod writeMethod) {
        this.m_writeMethod.setIfAbsent((Object)writeMethod);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.name().hashCode();
        result = prime * result + this.declaringType().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyBean other = (PropertyBean)obj;
        return this.declaringType().equals(other.declaringType()) && this.name().equals(other.name());
    }

    public String toString() {
        return this.declaringType().name() + "#" + this.name();
    }
}

