/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.prop;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.eclipse.scout.sdk.core.model.query.AbstractQuery;
import org.eclipse.scout.sdk.core.s.model.js.objects.IScoutJsObject;
import org.eclipse.scout.sdk.core.s.model.js.objects.ScoutJsObjectQuery;
import org.eclipse.scout.sdk.core.s.model.js.prop.ScoutJsProperty;

public class ScoutJsPropertyQuery
extends AbstractQuery<ScoutJsProperty> {
    private final IScoutJsObject m_object;
    private String m_name;
    private boolean m_includeSupers;

    public ScoutJsPropertyQuery(IScoutJsObject object) {
        this.m_object = object;
    }

    protected IScoutJsObject object() {
        return this.m_object;
    }

    public ScoutJsPropertyQuery withName(String name) {
        this.m_name = name;
        return this;
    }

    protected String name() {
        return this.m_name;
    }

    public ScoutJsPropertyQuery withSupers(boolean includeSupers) {
        this.m_includeSupers = includeSupers;
        return this;
    }

    protected boolean isIncludeSupers() {
        return this.m_includeSupers;
    }

    protected Stream<ScoutJsProperty> createStream() {
        String name;
        IScoutJsObject obj = this.object();
        LinkedHashMap<String, ScoutJsProperty> properties = new LinkedHashMap<String, ScoutJsProperty>(obj.properties());
        List superClasses = obj.declaringClass().supers().stream().toList();
        if (!superClasses.isEmpty()) {
            ((ScoutJsObjectQuery)((Object)((ScoutJsObjectQuery)((Object)obj.scoutJsModel().findScoutObjects().withIncludeDependencies(true))).withDeclaringClasses(superClasses))).stream().flatMap(superObject -> superObject.properties().values().stream()).forEach(inheritedProperty -> this.updateOrAddSuperPropertyIfNecessary((Map<String, ScoutJsProperty>)properties, (ScoutJsProperty)inheritedProperty));
        }
        if ((name = this.name()) == null) {
            return properties.values().stream();
        }
        return Stream.ofNullable(properties.get(name));
    }

    protected void updateOrAddSuperPropertyIfNecessary(Map<String, ScoutJsProperty> properties, ScoutJsProperty inheritedProperty) {
        BiFunction<String, ScoutJsProperty, ScoutJsProperty> chooseProperty = (name, lower) -> ScoutJsProperty.choose(inheritedProperty, lower);
        if (this.isIncludeSupers()) {
            properties.compute(inheritedProperty.name(), chooseProperty);
        } else {
            properties.computeIfPresent(inheritedProperty.name(), chooseProperty);
        }
    }
}

