/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.typescript.model.api.spliterator;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.eclipse.scout.sdk.core.typescript.model.spi.NodeModuleSpi;

public class PackageJsonDependencySpliterator
implements Spliterator<NodeModuleSpi> {
    private final boolean m_recursive;
    private final int m_characteristics;
    private final Deque<NodeModuleSpi> m_dek;
    private final Set<NodeModuleSpi> m_dependenciesAddedToDek;
    private boolean m_withSelf;

    public PackageJsonDependencySpliterator(Collection<NodeModuleSpi> firstLevelDependencies, boolean recursive, boolean withSelf) {
        this.m_recursive = recursive;
        this.m_withSelf = withSelf;
        this.m_dek = new ArrayDeque<NodeModuleSpi>(firstLevelDependencies);
        this.m_dependenciesAddedToDek = new HashSet<NodeModuleSpi>(firstLevelDependencies);
        int characteristics = 1296;
        if (!recursive && !withSelf) {
            characteristics |= 0x4040;
        }
        this.m_characteristics = characteristics;
    }

    @Override
    public boolean tryAdvance(Consumer<? super NodeModuleSpi> consumer) {
        block6: {
            NodeModuleSpi current;
            block5: {
                if (this.m_dek.isEmpty()) {
                    return false;
                }
                current = this.m_dek.removeFirst();
                consumer.accept(current);
                if (this.isRecursive()) break block5;
                if (!this.isWithSelf()) break block6;
            }
            current.packageJson().dependencies().stream().filter(this.m_dependenciesAddedToDek::add).forEach(this.m_dek::addLast);
            if (this.isWithSelf()) {
                this.m_withSelf = false;
            }
        }
        return true;
    }

    public boolean isRecursive() {
        return this.m_recursive;
    }

    public boolean isWithSelf() {
        return this.m_withSelf;
    }

    @Override
    public Spliterator<NodeModuleSpi> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        if (this.hasCharacteristics(64)) {
            return this.m_dek.size();
        }
        return Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.m_characteristics;
    }
}

