/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.scout.sdk.core.java.JavaTypes;
import org.eclipse.scout.sdk.core.java.ecj.AbstractMemberWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingAnnotationWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingMethodParameterWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.BindingTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.internal.MethodImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.AnnotatableSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.MethodSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeParameterSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class BindingMethodWithEcj
extends AbstractMemberWithEcj<IMethod>
implements MethodSpi {
    private final BindingTypeWithEcj m_declaringType;
    private final MethodBinding m_binding;
    private final FinalValue<TypeSpi> m_returnType;
    private final FinalValue<List<BindingAnnotationWithEcj>> m_annotations;
    private final FinalValue<String> m_name;
    private final FinalValue<List<TypeSpi>> m_exceptions;
    private final FinalValue<List<MethodParameterSpi>> m_arguments;
    private final FinalValue<List<TypeParameterSpi>> m_typeParameters;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_bodySource;
    private final FinalValue<SourceRange> m_javaDocSource;
    private final FinalValue<String> m_methodId;
    private int m_flags;

    protected BindingMethodWithEcj(AbstractJavaEnvironment env, BindingTypeWithEcj declaringType, MethodBinding binding) {
        super(env);
        this.m_declaringType = (BindingTypeWithEcj)((Object)Ensure.notNull((Object)((Object)declaringType)));
        this.m_binding = (MethodBinding)Ensure.notNull((Object)binding);
        this.m_flags = -1;
        this.m_returnType = new FinalValue();
        this.m_annotations = new FinalValue();
        this.m_name = new FinalValue();
        this.m_exceptions = new FinalValue();
        this.m_arguments = new FinalValue();
        this.m_typeParameters = new FinalValue();
        this.m_source = new FinalValue();
        this.m_bodySource = new FinalValue();
        this.m_javaDocSource = new FinalValue();
        this.m_methodId = new FinalValue();
    }

    public MethodSpi internalFindNewElement() {
        return SpiWithEcjUtils.findNewMethodIn(this.getDeclaringType(), this.getMethodId());
    }

    public String getMethodId() {
        return (String)this.m_methodId.computeIfAbsentAndGet(() -> JavaTypes.createMethodIdentifier((MethodSpi)this));
    }

    protected IMethod internalCreateApi() {
        return new MethodImplementor((MethodSpi)this);
    }

    public MethodBinding getInternalBinding() {
        return this.m_binding;
    }

    public List<BindingAnnotationWithEcj> getAnnotations() {
        return (List)this.m_annotations.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createBindingAnnotations((AnnotatableSpi)this, (Binding)SpiWithEcjUtils.nvl(this.m_binding.original(), this.m_binding)));
    }

    public int getFlags() {
        if (this.m_flags < 0) {
            this.m_flags = SpiWithEcjUtils.getMethodFlags(this.m_binding.modifiers, false, SpiWithEcjUtils.hasDeprecatedAnnotation(this.getAnnotations()));
        }
        return this.m_flags;
    }

    public String getElementName() {
        return (String)this.m_name.computeIfAbsentAndGet(() -> {
            if (this.m_binding.isConstructor()) {
                return this.m_declaringType.getElementName();
            }
            return new String(this.m_binding.selector);
        });
    }

    protected static ReferenceBinding[] getExceptionBindings(BindingMethodWithEcj m) {
        return m.m_binding.thrownExceptions;
    }

    public List<TypeSpi> getExceptionTypes() {
        return (List)this.m_exceptions.computeIfAbsentAndGet(() -> SpiWithEcjUtils.bindingsToTypes(this.javaEnvWithEcj(), (TypeBinding[])BindingMethodWithEcj.getExceptionBindings(this), () -> (TypeBinding[])this.withNewElement(BindingMethodWithEcj::getExceptionBindings)));
    }

    protected static TypeBinding getReturnTypeBinding(BindingMethodWithEcj m) {
        return m.m_binding.returnType;
    }

    public TypeSpi getReturnType() {
        return (TypeSpi)this.m_returnType.computeIfAbsentAndGet(() -> {
            if (this.isConstructor()) {
                return null;
            }
            return SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), BindingMethodWithEcj.getReturnTypeBinding(this), () -> (TypeBinding)this.withNewElement(BindingMethodWithEcj::getReturnTypeBinding));
        });
    }

    public List<MethodParameterSpi> getParameters() {
        return (List)this.m_arguments.computeIfAbsentAndGet(() -> {
            TypeBinding[] arguments = this.m_binding.parameters;
            if (arguments == null || arguments.length < 1) {
                return Collections.emptyList();
            }
            ArrayList<BindingMethodParameterWithEcj> result = new ArrayList<BindingMethodParameterWithEcj>(arguments.length);
            MethodBinding originalBinding = this.m_binding.original();
            AbstractMethodDeclaration sourceMethod = this.m_binding.sourceMethod();
            AbstractMethodDeclaration originalSourceMethod = originalBinding.sourceMethod();
            for (int i = 0; i < arguments.length; ++i) {
                char[] name = BindingMethodWithEcj.getParamName(this.m_binding, sourceMethod, i);
                if (name == null && (name = BindingMethodWithEcj.getParamName(originalBinding, originalSourceMethod, i)) == null) {
                    name = ("arg" + i).toCharArray();
                }
                int flags = 0;
                if (sourceMethod != null && sourceMethod.arguments.length > i) {
                    flags = sourceMethod.arguments[i].modifiers;
                } else if (originalSourceMethod != null && originalSourceMethod.arguments.length > i) {
                    flags = originalSourceMethod.arguments[i].modifiers;
                }
                result.add(this.javaEnvWithEcj().createBindingMethodParameter(this, arguments[i], name, flags, i));
            }
            return result;
        });
    }

    protected static char[] getParamName(MethodBinding b, AbstractMethodDeclaration sourceMethod, int paramIndex) {
        if (b.parameterNames.length > paramIndex) {
            return b.parameterNames[paramIndex];
        }
        if (sourceMethod != null && sourceMethod.arguments.length > paramIndex) {
            return sourceMethod.arguments[paramIndex].name;
        }
        return null;
    }

    protected TypeVariableBinding[] getTypeVariables() {
        return SpiWithEcjUtils.nvl(this.m_binding.original(), this.m_binding).typeVariables();
    }

    public boolean hasTypeParameters() {
        TypeVariableBinding[] typeVariables = this.getTypeVariables();
        return typeVariables != null && typeVariables.length > 0;
    }

    public List<TypeParameterSpi> getTypeParameters() {
        return (List)this.m_typeParameters.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createTypeParameters(this, this.getTypeVariables()));
    }

    public BindingTypeWithEcj getDeclaringType() {
        return this.m_declaringType;
    }

    public boolean isConstructor() {
        return this.m_binding.isConstructor();
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> {
            AbstractMethodDeclaration decl = SpiWithEcjUtils.sourceMethodOf(this.m_binding);
            if (decl == null) {
                return null;
            }
            return this.javaEnvWithEcj().getSource(this.m_declaringType.getCompilationUnit(), decl.declarationSourceStart, decl.declarationSourceEnd);
        });
    }

    public SourceRange getSourceOfBody() {
        return (SourceRange)this.m_bodySource.computeIfAbsentAndGet(() -> {
            AbstractMethodDeclaration decl = SpiWithEcjUtils.sourceMethodOf(this.m_binding);
            if (decl == null) {
                return null;
            }
            return this.javaEnvWithEcj().getSource(this.m_declaringType.getCompilationUnit(), decl.bodyStart, decl.bodyEnd);
        });
    }

    public SourceRange getJavaDoc() {
        return (SourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> {
            AbstractMethodDeclaration decl = SpiWithEcjUtils.sourceMethodOf(this.m_binding);
            if (decl == null) {
                return null;
            }
            return SpiWithEcjUtils.createSourceRange((ASTNode)decl.javadoc, this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj());
        });
    }

    public SourceRange getSourceOfDeclaration() {
        return SpiWithEcjUtils.createSourceRange((ASTNode)SpiWithEcjUtils.sourceMethodOf(this.m_binding), this.m_declaringType.getCompilationUnit(), this.javaEnvWithEcj());
    }
}

