/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.ecj;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MissingTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.scout.sdk.core.java.ecj.AbstractJavaElementWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.AbstractTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationImportWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.DeclarationTypeWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.JavaEnvironmentWithEcj;
import org.eclipse.scout.sdk.core.java.ecj.SpiWithEcjUtils;
import org.eclipse.scout.sdk.core.java.model.api.ICompilationUnit;
import org.eclipse.scout.sdk.core.java.model.api.internal.CompilationUnitImplementor;
import org.eclipse.scout.sdk.core.java.model.spi.AbstractJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.spi.ClasspathSpi;
import org.eclipse.scout.sdk.core.java.model.spi.CompilationUnitSpi;
import org.eclipse.scout.sdk.core.java.model.spi.PackageSpi;
import org.eclipse.scout.sdk.core.java.model.spi.TypeSpi;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.SourceRange;

public class DeclarationCompilationUnitWithEcj
extends AbstractJavaElementWithEcj<ICompilationUnit>
implements CompilationUnitSpi {
    private final CompilationUnitDeclaration m_astNode;
    private final FinalValue<PackageSpi> m_package;
    private final FinalValue<String> m_fileName;
    private final FinalValue<TypeSpi> m_mainType;
    private final FinalValue<List<DeclarationTypeWithEcj>> m_types;
    private final FinalValue<List<DeclarationImportWithEcj>> m_imports;
    private final FinalValue<SourceRange> m_source;
    private final FinalValue<SourceRange> m_javaDocSource;
    private final FinalValue<Path> m_absolutePath;
    private final FinalValue<ClasspathSpi> m_containingClasspathFolder;

    protected DeclarationCompilationUnitWithEcj(AbstractJavaEnvironment env, CompilationUnitDeclaration astNode) {
        super(env);
        this.m_astNode = (CompilationUnitDeclaration)Ensure.notNull((Object)astNode);
        this.m_package = new FinalValue();
        this.m_fileName = new FinalValue();
        this.m_mainType = new FinalValue();
        this.m_types = new FinalValue();
        this.m_imports = new FinalValue();
        this.m_source = new FinalValue();
        this.m_javaDocSource = new FinalValue();
        this.m_absolutePath = new FinalValue();
        this.m_containingClasspathFolder = new FinalValue();
    }

    protected static TypeBinding findBindingBySimpleName(String simpleName, DeclarationCompilationUnitWithEcj cu) {
        AbstractTypeWithEcj t = (AbstractTypeWithEcj)cu.findTypeBySimpleName(simpleName);
        if (t == null) {
            return null;
        }
        return t.getInternalBinding();
    }

    protected TypeSpi findTypeBySimpleNameInternal(String simpleName, Scope scopeForTypeLookup) {
        TypeBinding type = scopeForTypeLookup.getType(simpleName.toCharArray());
        if (type instanceof MissingTypeBinding || type instanceof ProblemReferenceBinding) {
            return null;
        }
        return SpiWithEcjUtils.bindingToType(this.javaEnvWithEcj(), type, () -> (TypeBinding)this.withNewElement(x -> DeclarationCompilationUnitWithEcj.findBindingBySimpleName(simpleName, x)));
    }

    public CompilationUnitSpi internalFindNewElement() {
        return this.getTypes().stream().map(DeclarationTypeWithEcj::internalFindNewElement).filter(Objects::nonNull).findFirst().map(TypeSpi::getCompilationUnit).orElse(null);
    }

    protected ICompilationUnit internalCreateApi() {
        return new CompilationUnitImplementor((CompilationUnitSpi)this);
    }

    public boolean isSynthetic() {
        return false;
    }

    public CompilationUnitDeclaration getInternalCompilationUnitDeclaration() {
        return this.m_astNode;
    }

    public Path absolutePath() {
        return (Path)this.m_absolutePath.computeIfAbsentAndGet(this::computeAbsolutePath);
    }

    protected Path computeAbsolutePath() {
        CompilationResult compilationResult = this.getInternalCompilationUnitDeclaration().compilationResult();
        if (compilationResult == null) {
            return null;
        }
        char[] fileName = compilationResult.getFileName();
        if (fileName == null) {
            return null;
        }
        return Paths.get(new String(fileName), new String[0]);
    }

    public ClasspathSpi getContainingClasspathFolder() {
        return (ClasspathSpi)this.m_containingClasspathFolder.computeIfAbsentAndGet(this::computeContainingClasspathFolder);
    }

    protected ClasspathSpi computeContainingClasspathFolder() {
        Path myPath = this.absolutePath();
        if (myPath == null) {
            return null;
        }
        return this.getJavaEnvironment().getClasspath().stream().filter(ClasspathSpi::isDirectory).filter(cp -> myPath.startsWith(cp.getPath())).findFirst().orElse(null);
    }

    public PackageSpi getPackage() {
        return (PackageSpi)this.m_package.computeIfAbsentAndGet(() -> {
            char[][] importName;
            ImportReference currentPackage = this.m_astNode.currentPackage;
            if (currentPackage != null && (importName = currentPackage.getImportName()) != null && importName.length > 0) {
                return this.javaEnvWithEcj().createPackage(CharOperation.toString((char[][])importName));
            }
            return this.javaEnvWithEcj().createDefaultPackage();
        });
    }

    public TypeSpi findTypeBySimpleName(String simpleName) {
        TypeSpi result = this.findTypeBySimpleNameInternal(simpleName, (Scope)this.m_astNode.scope);
        if (result != null) {
            return result;
        }
        for (SourceTypeBinding stb : this.m_astNode.scope.topLevelTypes) {
            result = this.findTypeInSourceTypeBindingRec((Binding)stb, simpleName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected TypeSpi findTypeInSourceTypeBindingRec(Binding b, String simpleName) {
        if (!(b instanceof SourceTypeBinding)) {
            return null;
        }
        SourceTypeBinding stb = (SourceTypeBinding)b;
        TypeSpi result = this.findTypeBySimpleNameInternal(simpleName, (Scope)stb.scope);
        if (result != null) {
            return result;
        }
        for (ReferenceBinding mb : stb.memberTypes) {
            result = this.findTypeInSourceTypeBindingRec((Binding)mb, simpleName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public String getElementName() {
        return (String)this.m_fileName.computeIfAbsentAndGet(() -> {
            char[] array = this.m_astNode.getFileName();
            int i = Math.max(CharOperation.lastIndexOf((char)'/', (char[])array), CharOperation.lastIndexOf((char)'\\', (char[])array));
            if (i >= 0) {
                return new String(array, i + 1, array.length - i - 1);
            }
            return new String(array);
        });
    }

    public TypeSpi getMainType() {
        return (TypeSpi)this.m_mainType.computeIfAbsentAndGet(() -> {
            String mainTypeName = new String(this.m_astNode.getMainTypeName());
            return this.getTypes().stream().filter(t -> mainTypeName.equals(t.getElementName())).findFirst().orElse(null);
        });
    }

    public List<DeclarationTypeWithEcj> getTypes() {
        return (List)this.m_types.computeIfAbsentAndGet(() -> {
            TypeDeclaration[] types = this.m_astNode.types;
            if (types == null || types.length < 1) {
                return Collections.emptyList();
            }
            JavaEnvironmentWithEcj env = this.javaEnvWithEcj();
            return Arrays.stream(types).map(td -> env.createDeclarationType(this, null, (TypeDeclaration)td)).collect(Collectors.toList());
        });
    }

    public List<DeclarationImportWithEcj> getImports() {
        return (List)this.m_imports.computeIfAbsentAndGet(() -> {
            ImportReference[] imports = this.m_astNode.imports;
            if (imports == null || imports.length < 1) {
                return Collections.emptyList();
            }
            JavaEnvironmentWithEcj env = this.javaEnvWithEcj();
            return Arrays.stream(imports).map(imp -> env.createDeclarationImport(this, (ImportReference)imp)).collect(Collectors.toList());
        });
    }

    public SourceRange getSource() {
        return (SourceRange)this.m_source.computeIfAbsentAndGet(() -> SpiWithEcjUtils.createSourceRange((ASTNode)this.m_astNode, this, this.javaEnvWithEcj()));
    }

    public SourceRange getJavaDoc() {
        return (SourceRange)this.m_javaDocSource.computeIfAbsentAndGet(() -> {
            Javadoc doc = this.m_astNode.javadoc;
            if (doc != null) {
                return SpiWithEcjUtils.createSourceRange((ASTNode)doc, this, this.javaEnvWithEcj());
            }
            if (this.m_astNode.currentPackage != null && this.m_astNode.currentPackage.declarationSourceStart > 0) {
                return this.javaEnvWithEcj().getSource(this, 0, this.m_astNode.currentPackage.declarationSourceStart - 1);
            }
            return null;
        });
    }
}

