/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.jsdt.ui.text.IColorManager;
import org.eclipse.wst.jsdt.ui.text.IColorManagerExtension;

public class JavaColorManager
implements IColorManager,
IColorManagerExtension {
    protected Map fKeyTable = new HashMap(10);
    protected Map fDisplayTable = new HashMap(2);
    private boolean fAutoDisposeOnDisplayDispose;

    public JavaColorManager() {
        this(true);
    }

    public JavaColorManager(boolean autoDisposeOnDisplayDispose) {
        this.fAutoDisposeOnDisplayDispose = autoDisposeOnDisplayDispose;
    }

    public void dispose(Display display) {
        Map colorTable = (Map)this.fDisplayTable.get(display);
        if (colorTable != null) {
            for (Color color : colorTable.values()) {
                if (color == null || color.isDisposed()) continue;
                color.dispose();
            }
        }
    }

    public Color getColor(RGB rgb) {
        Color color;
        if (rgb == null) {
            return null;
        }
        final Display display = Display.getCurrent();
        HashMap<RGB, Color> colorTable = (HashMap<RGB, Color>)this.fDisplayTable.get(display);
        if (colorTable == null) {
            colorTable = new HashMap<RGB, Color>(10);
            this.fDisplayTable.put(display, colorTable);
            if (this.fAutoDisposeOnDisplayDispose) {
                display.disposeExec(new Runnable(){

                    @Override
                    public void run() {
                        JavaColorManager.this.dispose(display);
                    }
                });
            }
        }
        if ((color = (Color)colorTable.get(rgb)) == null) {
            color = new Color((Device)Display.getCurrent(), rgb);
            colorTable.put(rgb, color);
        }
        return color;
    }

    public void dispose() {
        if (!this.fAutoDisposeOnDisplayDispose) {
            this.dispose(Display.getCurrent());
        }
    }

    @Override
    public Color getColor(String key) {
        if (key == null) {
            return null;
        }
        RGB rgb = (RGB)this.fKeyTable.get(key);
        return this.getColor(rgb);
    }

    @Override
    public void bindColor(String key, RGB rgb) {
        Object value = this.fKeyTable.get(key);
        if (value != null) {
            throw new UnsupportedOperationException();
        }
        this.fKeyTable.put(key, rgb);
    }

    @Override
    public void unbindColor(String key) {
        this.fKeyTable.remove(key);
    }
}

