/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.service.policy.ui;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.ws.service.policy.IDescriptor;
import org.eclipse.wst.ws.service.policy.IServicePolicy;
import org.eclipse.wst.ws.service.policy.IStateEnumerationItem;
import org.eclipse.wst.ws.service.policy.ServicePolicyPlatform;
import org.eclipse.wst.ws.service.policy.ui.IEnableOperation;
import org.eclipse.wst.ws.service.policy.ui.ILaunchOperation;
import org.eclipse.wst.ws.service.policy.ui.IPolicyOperation;
import org.eclipse.wst.ws.service.policy.ui.ServicePolicyActivatorUI;
import org.eclipse.wst.ws.service.policy.utils.RegistryUtils;

public class BaseOperationImpl {
    private String id;
    private IDescriptor descriptor;
    private IPolicyOperation.OperationKind operationKind;
    private String policyIdPattern;
    private boolean multiSelect = false;
    private ILaunchOperation launchOperationObject;
    private IEnableOperation enableOperationObject;
    private String enumId;
    private IConfigurationElement enabledElement;
    private IConfigurationElement complexElement;
    private boolean workspaceOnly;
    private String defaultItem;
    private boolean useDefaultData;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isWorkspaceOnly() {
        return this.workspaceOnly;
    }

    public void setWorkspaceOnly(boolean workspaceOnly) {
        this.workspaceOnly = workspaceOnly;
    }

    public void setSelection(boolean isIcon) {
        this.operationKind = isIcon ? IPolicyOperation.OperationKind.iconSelection : IPolicyOperation.OperationKind.selection;
    }

    public IDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IPolicyOperation.OperationKind getOperationKind() {
        return this.operationKind;
    }

    public String getEnumerationId() {
        return this.enumId;
    }

    public void setEnumerationId(String enumId) {
        this.enumId = enumId;
        this.operationKind = IPolicyOperation.OperationKind.enumeration;
    }

    public String getPolicyIdPattern() {
        return this.policyIdPattern;
    }

    public boolean isEnabled(List<IServicePolicy> selectedPolicies) {
        boolean result = true;
        if (!this.multiSelect && selectedPolicies.size() > 1) {
            result = false;
        }
        if (result && this.enabledElement != null && this.enableOperationObject == null) {
            try {
                String enabledClassName = RegistryUtils.getAttributeName((IConfigurationElement)this.enabledElement, (String)"enabledclass");
                this.enableOperationObject = (IEnableOperation)this.enabledElement.createExecutableExtension(enabledClassName);
            }
            catch (Exception exc) {
                ServicePolicyActivatorUI.logError("Error loading service policy ui \"enabled\" class.", exc);
            }
            if (this.enableOperationObject != null) {
                result = this.enableOperationObject.isEnabled(selectedPolicies);
            }
        }
        return result;
    }

    public void launchOperation(IServicePolicy thisPolicy, List<IServicePolicy> selectedPolicies) {
        if (this.launchOperationObject == null) {
            try {
                String launchClassName = RegistryUtils.getAttributeName((IConfigurationElement)this.complexElement, (String)"launchclass");
                this.launchOperationObject = (ILaunchOperation)this.complexElement.createExecutableExtension(launchClassName);
            }
            catch (Exception exc) {
                ServicePolicyActivatorUI.logError("Error loading service policy ui launch class.", exc);
            }
        }
        if (this.launchOperationObject != null) {
            this.launchOperationObject.launch(selectedPolicies);
        }
    }

    public boolean isMultiSelect() {
        return this.multiSelect;
    }

    public void setMultiSelect(boolean multiSelect) {
        this.multiSelect = multiSelect;
    }

    public void setDescriptor(IDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setPolicyIdPattern(String policyIdPattern) {
        this.policyIdPattern = policyIdPattern;
    }

    public void setEnabledElement(IConfigurationElement enabledElement) {
        this.enabledElement = enabledElement;
    }

    public void setComplexElement(IConfigurationElement complexElement) {
        this.complexElement = complexElement;
        this.operationKind = IPolicyOperation.OperationKind.complex;
    }

    public void setDefaultItem(String defaultItem) {
        this.defaultItem = defaultItem;
    }

    public String getDefaultItem() {
        ServicePolicyPlatform platform;
        List enumList;
        if (this.defaultItem == null && (enumList = (platform = ServicePolicyPlatform.getInstance()).getStateEnumeration(this.enumId)) != null) {
            this.defaultItem = ((IStateEnumerationItem)enumList.get(0)).getId();
            for (IStateEnumerationItem item : enumList) {
                if (!item.isDefault()) continue;
                this.defaultItem = item.getId();
                break;
            }
        }
        return this.defaultItem;
    }

    public boolean isUseDefaultData() {
        return this.useDefaultData;
    }

    public void setUseDefaultData(boolean useDefaultData) {
        this.useDefaultData = useDefaultData;
    }
}

