/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.environment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IFuture;
import org.eclipse.scout.sdk.core.util.FinalValue;
import org.eclipse.scout.sdk.core.util.Strings;

public class SdkFuture<V>
extends CompletableFuture<Supplier<V>>
implements IFuture<V> {
    public static <T> IFuture<T> completed(T result) {
        return SdkFuture.completed(result, null);
    }

    public static <T> IFuture<T> completed(T result, Throwable error) {
        return SdkFuture.completed(() -> result, error);
    }

    public static <T> IFuture<T> completed(Supplier<T> resultExtractor, Throwable error) {
        return new SdkFuture<T>().doCompletion(false, error, resultExtractor);
    }

    public static void awaitAll(Iterable<? extends IFuture<?>> futures) {
        if (futures == null) {
            return;
        }
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        for (IFuture<?> future : futures) {
            if (future == null) continue;
            try {
                future.join();
            }
            catch (CompletionException e) {
                errors.add(e.getCause());
            }
            catch (CancellationException e) {
                SdkLog.debug((CharSequence)"Cancellation silently ignored", (Object[])new Object[]{SdkLog.onTrace((Object)e)});
            }
        }
        if (errors.isEmpty()) {
            return;
        }
        throw new CompositeException(errors);
    }

    public static void awaitAllLoggingOnError(Iterable<IFuture<?>> futures) {
        try {
            SdkFuture.awaitAll(futures);
        }
        catch (CompositeException e) {
            e.exceptions().forEach(xva$0 -> SdkLog.error((Object[])new Object[]{xva$0}));
        }
    }

    @Override
    public SdkFuture<V> awaitDoneThrowingOnErrorOrCancel() {
        this.result();
        return this;
    }

    @Override
    public SdkFuture<V> awaitDoneThrowingOnError() {
        try {
            this.join();
        }
        catch (CancellationException e) {
            SdkLog.debug((CharSequence)"Cancellation silently ignored", (Object[])new Object[]{SdkLog.onTrace((Object)e)});
        }
        return this;
    }

    protected SdkFuture<V> doCompletion(boolean isCanceled, Throwable error, Supplier<V> resultExtractor) {
        if (isCanceled) {
            this.completeExceptionally(new CancellationException());
        } else if (error == null) {
            if (resultExtractor == null) {
                this.complete(() -> null);
            } else {
                FinalValue cachedResult = new FinalValue();
                this.complete(() -> cachedResult.computeIfAbsentAndGet(resultExtractor));
            }
        } else {
            SdkLog.debug((CharSequence)"Asynchronous task completed with exception", (Object[])new Object[]{error});
            this.completeExceptionally(error);
        }
        return this;
    }

    @Override
    public V result() {
        try {
            return (V)((Supplier)this.join()).get();
        }
        catch (CompletionException e) {
            SdkLog.debug((CharSequence)"Future completed exceptionally.", (Object[])new Object[]{e});
            Throwable cause = e.getCause();
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw e;
        }
    }

    public static class CompositeException
    extends RuntimeException {
        private static final long serialVersionUID = -2565677977298841153L;
        private final Collection<Throwable> m_throwables;

        public CompositeException(Collection<Throwable> throwables) {
            super("Composite exception was thrown with embedded exceptions (see details before)");
            this.m_throwables = new ArrayList<Throwable>(throwables);
        }

        public Collection<Throwable> exceptions() {
            return Collections.unmodifiableCollection(this.m_throwables);
        }

        @Override
        public String toString() {
            return this.m_throwables.stream().map(throwable -> throwable.toString() + Strings.fromThrowable((Throwable)throwable) + System.lineSeparator()).collect(Collectors.joining("", "Nested Exception: [" + System.lineSeparator(), "]" + System.lineSeparator() + super.toString()));
        }
    }
}

