/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.log;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class FormattingTuple {
    private final String m_message;
    private final List<Throwable> m_throwables;

    FormattingTuple(String message, List<Throwable> throwables) {
        this.m_message = message;
        this.m_throwables = throwables;
    }

    public String message() {
        return this.m_message;
    }

    public List<Throwable> throwables() {
        return Collections.unmodifiableList(this.m_throwables);
    }

    public Optional<Throwable> firstThrowable() {
        return this.throwables().stream().findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormattingTuple other = (FormattingTuple)o;
        return this.m_message.equals(other.m_message) && this.m_throwables.equals(other.m_throwables);
    }

    public int hashCode() {
        return 31 * this.m_message.hashCode() + this.m_throwables.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FormattingTuple{");
        sb.append("message='").append(this.m_message).append('\'');
        sb.append(", throwables=").append(this.m_throwables);
        sb.append('}');
        return sb.toString();
    }
}

