/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.java.generator.method;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.scout.sdk.core.builder.ISourceBuilder;
import org.eclipse.scout.sdk.core.generator.ISourceGenerator;
import org.eclipse.scout.sdk.core.java.builder.IJavaBuilderContext;
import org.eclipse.scout.sdk.core.java.builder.IJavaSourceBuilder;
import org.eclipse.scout.sdk.core.java.builder.body.IMethodBodyBuilder;
import org.eclipse.scout.sdk.core.java.generator.IAnnotatableGenerator;
import org.eclipse.scout.sdk.core.java.generator.annotation.AnnotationGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.IMethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.method.MethodGenerator;
import org.eclipse.scout.sdk.core.java.generator.type.ITypeGenerator;
import org.eclipse.scout.sdk.core.java.model.api.Flags;
import org.eclipse.scout.sdk.core.java.model.api.IMethod;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.java.transformer.IWorkingCopyTransformer;
import org.eclipse.scout.sdk.core.util.Ensure;

public class MethodOverrideGenerator<TYPE extends IMethodGenerator<TYPE, BODY>, BODY extends IMethodBodyBuilder<?>>
extends MethodGenerator<TYPE, BODY> {
    private final IWorkingCopyTransformer m_transformer;

    public static IMethodGenerator<?, ?> createOverride() {
        return MethodOverrideGenerator.createOverride(null);
    }

    public static IMethodGenerator<?, ?> createOverride(IWorkingCopyTransformer transformer) {
        return new MethodOverrideGenerator(transformer);
    }

    protected MethodOverrideGenerator(IWorkingCopyTransformer transformer) {
        this.m_transformer = transformer;
    }

    protected IMethodGenerator<?, ?> createDefaultOverrideGenerator(IMethod template) {
        boolean isFromInterface = Flags.isInterface(template.requireDeclaringType().flags());
        boolean needsImplementation = isFromInterface || Flags.isAbstract(template.flags());
        IMethodGenerator innerGenerator = (IMethodGenerator)((IMethodGenerator)((IMethodGenerator)((IMethodGenerator)template.toWorkingCopy(this.m_transformer).withoutAllAnnotations()).withComment(null)).withAnnotation(AnnotationGenerator.createOverride())).withoutFlags(67072);
        innerGenerator.withBody(b -> b.append(this.body().orElseGet(() -> this.createDefaultMethodBody(needsImplementation)).generalize(inner -> this.createMethodBodyBuilder((ISourceBuilder<?>)inner, innerGenerator))));
        innerGenerator.parameters().forEach(IAnnotatableGenerator::withoutAllAnnotations);
        this.returnTypeFunc().ifPresent(innerGenerator::withReturnTypeFunc);
        if (isFromInterface) {
            innerGenerator.asPublic();
        }
        return innerGenerator;
    }

    protected ISourceGenerator<BODY> createDefaultMethodBody(boolean needsImplementation) {
        return b -> {
            if (needsImplementation) {
                b.appendAutoGenerated();
            } else {
                b.appendSuperCall();
            }
        };
    }

    protected Optional<IMethodGenerator<?, ?>> createOverrideGenerator(IMethod template) {
        return IWorkingCopyTransformer.transform(this.m_transformer, template, () -> this.createDefaultOverrideGenerator(template), (t, i) -> t.transformMethod((IWorkingCopyTransformer.ITransformInput<IMethod, IMethodGenerator<?, ?>>)i));
    }

    protected Optional<IMethod> findMethodToOverride(IType container, IJavaBuilderContext context) {
        Map templateCandidates = container.methods().withSuperTypes(true).stream().filter(m -> m.elementName().equals(this.elementName(context).orElseThrow(() -> Ensure.newFail((CharSequence)"To override a method at least the method name must be specified.", (Object[])new Object[0])))).collect(Collectors.toMap(IMethod::identifier, Function.identity(), (a, b) -> a));
        if (templateCandidates.isEmpty()) {
            return Optional.empty();
        }
        if (templateCandidates.size() == 1) {
            return Optional.of((IMethod)templateCandidates.values().iterator().next());
        }
        return Optional.ofNullable((IMethod)templateCandidates.get(this.identifier(context)));
    }

    @Override
    protected void build(IJavaSourceBuilder<?> builder) {
        ITypeGenerator declaring = (ITypeGenerator)Ensure.instanceOf(this.declaringGenerator().orElse(null), ITypeGenerator.class, (CharSequence)"Method can only be overridden if existing in a type.", (Object[])new Object[0]);
        this.createOverrideGenerator(declaring.getHierarchyType(builder.context()), builder.context()).ifPresent(overrideGenerator -> overrideGenerator.generate(builder));
    }

    protected Optional<IMethodGenerator<?, ?>> createOverrideGenerator(IType tmpType, IJavaBuilderContext context) {
        IMethod template = this.findMethodToOverride(tmpType, context).orElseThrow(() -> Ensure.newFail((CharSequence)"Method '{}' cannot be found in the super hierarchy.", (Object[])new Object[]{this.elementName(context).orElse(null)}));
        return this.createOverrideGenerator(template);
    }
}

