/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.index.Index;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchDocument;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.wst.jsdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.wst.jsdt.internal.core.search.processing.JobManager;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class AddLibraryFileToIndex
extends IndexRequest {
    IPath absolutePath;
    char[][] inclusionPatterns;
    char[][] exclusionPatterns;

    public AddLibraryFileToIndex(IFile resource, IndexManager manager) {
        super(resource.getFullPath(), manager);
        this.absolutePath = resource.getLocation();
    }

    public AddLibraryFileToIndex(IPath jarPath, IndexManager manager) {
        this(jarPath, null, null, manager);
    }

    public AddLibraryFileToIndex(IPath filePath, char[][] inclusionPatterns, char[][] exclusionPatterns, IndexManager manager) {
        super(filePath, manager);
        this.inclusionPatterns = inclusionPatterns;
        this.exclusionPatterns = exclusionPatterns;
    }

    public boolean equals(Object o) {
        if (o instanceof AddLibraryFileToIndex && this.containerPath != null) {
            return this.containerPath.equals((Object)((AddLibraryFileToIndex)o).containerPath);
        }
        return false;
    }

    public int hashCode() {
        if (this.containerPath != null) {
            return this.containerPath.hashCode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        try {
            Index index = this.manager.getIndexForUpdate(this.containerPath, false, false);
            if (index != null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> no indexing required (index already exists) for " + this.containerPath);
                return true;
            }
            index = this.manager.getIndexForUpdate(this.containerPath, true, true);
            if (index == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index could not be created for " + this.containerPath);
                return true;
            }
            ReadWriteMonitor monitor = index.monitor;
            if (monitor == null) {
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> index for " + this.containerPath + " just got deleted");
                return true;
            }
            try {
                long initialTime;
                Path libraryFilePath;
                block49: {
                    File file;
                    SearchParticipant participant;
                    block47: {
                        block48: {
                            String[] paths;
                            libraryFilePath = null;
                            monitor.enterWrite();
                            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                                System.out.println("(" + Thread.currentThread() + ") [AddJarFileToIndex.execute()] Creating ZipFile on " + this.containerPath);
                            }
                            libraryFilePath = (Path)this.containerPath;
                            if (this.isCancelled) {
                                if (!JobManager.VERBOSE) return false;
                                Util.verbose("-> indexing of " + libraryFilePath.toString() + " has been cancelled");
                                return false;
                            }
                            if (JobManager.VERBOSE) {
                                Util.verbose("-> indexing " + libraryFilePath.toString());
                            }
                            initialTime = System.currentTimeMillis();
                            if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(libraryFilePath.lastSegment()) && (paths = index.queryDocumentNames("")) != null) {
                                boolean needToReindex;
                                int max = paths.length;
                                String EXISTS = "OK";
                                String DELETED = "DELETED";
                                SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                                int i = 0;
                                while (true) {
                                    if (i >= max) {
                                        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(libraryFilePath.toPortableString())) {
                                            indexedFileNames.put(libraryFilePath.toPortableString(), EXISTS);
                                        }
                                        boolean bl = needToReindex = indexedFileNames.elementSize != max;
                                    }
                                    indexedFileNames.put(paths[i], DELETED);
                                    ++i;
                                }
                                if (!needToReindex) {
                                    Object[] valueTable = indexedFileNames.valueTable;
                                    int i2 = 0;
                                    int l = valueTable.length;
                                    while (i2 < l) {
                                        if (valueTable[i2] == DELETED) {
                                            needToReindex = true;
                                            break;
                                        }
                                        ++i2;
                                    }
                                    if (!needToReindex) {
                                        if (JobManager.VERBOSE) {
                                            Util.verbose("-> no indexing required (index is consistent with library) for " + libraryFilePath.lastSegment() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                                        }
                                        this.manager.saveIndex(index);
                                        return true;
                                    }
                                }
                            }
                            participant = SearchEngine.getDefaultSearchParticipant();
                            index = this.manager.recreateIndex(this.containerPath);
                            if (index == null) {
                                this.manager.removeIndex(this.containerPath);
                                return false;
                            }
                            IPath filePath = this.absolutePath != null ? this.absolutePath : this.containerPath;
                            file = new File(filePath.toOSString());
                            if (!file.isFile()) break block47;
                            if (!Util.isJavaLikeFileName(file.getName())) break block48;
                            if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                                this.indexFile(file, participant, index, (IPath)libraryFilePath);
                                break block49;
                            } else if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isExcluded(file.getPath().toCharArray(), this.inclusionPatterns, this.exclusionPatterns, false)) {
                                this.indexFile(file, participant, index, (IPath)libraryFilePath);
                            }
                            break block49;
                        }
                        if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isArchiveFileName(file.getName())) {
                            try (ZipFile zip = new ZipFile(file);){
                                Enumeration<? extends ZipEntry> e = zip.entries();
                                while (e.hasMoreElements()) {
                                    if (this.isCancelled) {
                                        if (!JobManager.VERBOSE) return false;
                                        Util.verbose("-> indexing of " + zip.getName() + " has been cancelled");
                                        return false;
                                    }
                                    ZipEntry ze = e.nextElement();
                                    if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(ze.getName())) continue;
                                    StringBuffer buffer = new StringBuffer();
                                    try (InputStreamReader inputStreamReader = new InputStreamReader(zip.getInputStream(ze), "utf8");){
                                        char[] c = new char[2048];
                                        int length = 0;
                                        while ((length = inputStreamReader.read(c)) > -1) {
                                            buffer.append(c, 0, length);
                                        }
                                    }
                                    JavaSearchDocument entryDocument = new JavaSearchDocument(ze, (IPath)libraryFilePath, buffer.toString().toCharArray(), participant);
                                    this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
                                }
                            }
                        }
                        break block49;
                    }
                    if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                        this.indexDirectory(file, participant, index, (IPath)libraryFilePath);
                    } else if (this.exclusionPatterns != null && this.inclusionPatterns == null) {
                        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isExcluded(file.getPath().toCharArray(), this.inclusionPatterns, this.exclusionPatterns, true)) {
                            this.indexDirectory(file, participant, index, (IPath)libraryFilePath);
                        }
                    } else {
                        this.indexDirectory(file, participant, index, (IPath)libraryFilePath);
                    }
                }
                this.manager.saveIndex(index);
                if (!JobManager.VERBOSE) return true;
                Util.verbose("-> done indexing of " + libraryFilePath.toString() + " (" + (System.currentTimeMillis() - initialTime) + "ms)");
                return true;
            }
            finally {
                monitor.exitWrite();
            }
        }
        catch (IOException e) {
            if (JobManager.VERBOSE) {
                Util.verbose("-> failed to index " + this.containerPath + " because of the following exception:");
                e.printStackTrace();
            }
            this.manager.removeIndex(this.containerPath);
            return false;
        }
    }

    @Override
    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing " + this.containerPath.toString();
    }

    private void indexFile(File file, SearchParticipant participant, Index index, IPath libraryFilePath) {
        try {
            char[] classFileChars = org.eclipse.wst.jsdt.internal.compiler.util.Util.getFileCharContent(file, null);
            String packageName = "";
            JavaSearchDocument entryDocument = new JavaSearchDocument((IPath)new Path(file.getAbsolutePath()), classFileChars, participant, packageName);
            this.manager.indexDocument(entryDocument, participant, index, this.containerPath);
        }
        catch (Exception exception) {}
    }

    private void indexDirectory(File file, SearchParticipant participant, Index index, IPath libraryFilePath) {
        File[] files = file.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                        this.indexDirectory(files[i], participant, index, libraryFilePath);
                    } else if (this.exclusionPatterns != null && this.inclusionPatterns == null) {
                        if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isExcluded(files[i].getPath().toCharArray(), this.inclusionPatterns, this.exclusionPatterns, true)) {
                            this.indexDirectory(files[i], participant, index, libraryFilePath);
                        }
                    } else {
                        this.indexDirectory(files[i], participant, index, libraryFilePath);
                    }
                } else if (org.eclipse.wst.jsdt.internal.compiler.util.Util.isClassFileName(files[i].getName())) {
                    if (this.exclusionPatterns == null && this.inclusionPatterns == null) {
                        this.indexFile(files[i], participant, index, libraryFilePath);
                    } else if (!org.eclipse.wst.jsdt.internal.compiler.util.Util.isExcluded(files[i].getPath().toCharArray(), this.inclusionPatterns, this.exclusionPatterns, false)) {
                        this.indexFile(files[i], participant, index, libraryFilePath);
                    }
                }
                ++i;
            }
        }
    }
}

