/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.core.s.model.js.enums;

import java.util.List;
import java.util.Optional;
import org.eclipse.scout.sdk.core.s.model.js.IScoutJsElement;
import org.eclipse.scout.sdk.core.s.model.js.ScoutJsModel;
import org.eclipse.scout.sdk.core.s.model.js.enums.IScoutJsEnum;
import org.eclipse.scout.sdk.core.typescript.model.api.DataTypeFulfillsEvaluator;
import org.eclipse.scout.sdk.core.typescript.model.api.IConstantValue;
import org.eclipse.scout.sdk.core.typescript.model.api.IDataType;
import org.eclipse.scout.sdk.core.typescript.model.api.IES6Class;
import org.eclipse.scout.sdk.core.typescript.model.api.IField;
import org.eclipse.scout.sdk.core.typescript.model.api.INodeElement;
import org.eclipse.scout.sdk.core.typescript.model.api.IObjectLiteral;
import org.eclipse.scout.sdk.core.typescript.model.api.IVariable;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.FinalValue;

public class VariableScoutEnum
implements IScoutJsEnum {
    private final ScoutJsModel m_scoutJsModel;
    private final IVariable m_variable;
    private final IObjectLiteral m_objectLiteral;
    private final FinalValue<IES6Class> m_declaringClass = new FinalValue();
    private final FinalValue<INodeElement> m_reference = new FinalValue();
    private final FinalValue<List<String>> m_constants = new FinalValue();

    protected VariableScoutEnum(ScoutJsModel scoutJsModel, IVariable variable, IObjectLiteral objectLiteral) {
        this.m_scoutJsModel = scoutJsModel;
        this.m_variable = (IVariable)Ensure.notNull((Object)variable);
        this.m_objectLiteral = (IObjectLiteral)Ensure.notNull((Object)objectLiteral);
    }

    public static Optional<IScoutJsEnum> create(ScoutJsModel owner, IVariable variable) {
        if (owner == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(variable).map(IVariable::constantValue).flatMap(IConstantValue::asObjectLiteral).map(objectLiteral -> new VariableScoutEnum(owner, variable, (IObjectLiteral)objectLiteral));
    }

    protected IObjectLiteral objectLiteral() {
        return this.m_objectLiteral;
    }

    @Override
    public ScoutJsModel scoutJsModel() {
        return this.m_scoutJsModel;
    }

    @Override
    public String name() {
        return this.m_variable.name();
    }

    @Override
    public IES6Class declaringClass() {
        return (IES6Class)this.m_declaringClass.computeIfAbsentAndGet(() -> {
            IVariable patt0$temp = this.m_variable;
            if (patt0$temp instanceof IField) {
                IField field = (IField)patt0$temp;
                return field.declaringClass();
            }
            return null;
        });
    }

    @Override
    public String referenceName() {
        String namespace = Optional.ofNullable(this.declaringClass()).map(INodeElement::name).orElse(null);
        return IScoutJsElement.toQualifiedName(namespace, this.name());
    }

    @Override
    public INodeElement topLevelReference() {
        return (INodeElement)this.m_reference.computeIfAbsentAndGet(() -> {
            IVariable patt0$temp = this.m_variable;
            if (patt0$temp instanceof IField) {
                IField field = (IField)patt0$temp;
                return field.declaringClass();
            }
            return this.m_variable;
        });
    }

    @Override
    public List<String> constants() {
        return (List)this.m_constants.computeIfAbsentAndGet(this::parseConstants);
    }

    protected List<String> parseConstants() {
        return this.objectLiteral().properties().keySet().stream().toList();
    }

    @Override
    public boolean fulfills(IDataType dataType) {
        return new DataTypeFulfillsEvaluator(dt -> dt.objectLiteral().filter(objectLiteral -> objectLiteral == this.objectLiteral()).isPresent()).fulfills(dataType);
    }

    public String toString() {
        return this.objectLiteral().toString();
    }
}

