/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.apt.internal.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.m2e.apt.internal.utils.ProjectUtils;

public class AnnotationServiceLocator {
    private static final String JAVA5_FACTORY_NAME = "com.sun.mirror.apt.AnnotationProcessorFactory";
    private static final String JAVA6_FACTORY_NAME = "javax.annotation.processing.Processor";
    private static final String[] APT_SERVICES = new String[]{"com.sun.mirror.apt.AnnotationProcessorFactory", "javax.annotation.processing.Processor"};

    private AnnotationServiceLocator() {
    }

    public static Set<ServiceEntry> getAptServiceEntries(File jar) throws IOException {
        if (jar == null) {
            throw new IllegalArgumentException(String.format("Null %s.", File.class));
        }
        if (!jar.exists()) {
            throw new IllegalArgumentException(String.format("Specified file does not exist: %s", jar.getAbsolutePath()));
        }
        if (!jar.canRead()) {
            throw new IllegalArgumentException(String.format("Specified file not readable: %s", jar.getAbsolutePath()));
        }
        if (!ProjectUtils.isJar(jar)) {
            return Collections.emptySet();
        }
        HashSet<ServiceEntry> serviceEntries = new HashSet<ServiceEntry>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (JarFile jarFile = new JarFile(jar);){
            String[] stringArray = APT_SERVICES;
            int n = APT_SERVICES.length;
            int n2 = 0;
            while (n2 < n) {
                String serviceName = stringArray[n2];
                String providerName = "META-INF/services/" + serviceName;
                JarEntry provider = jarFile.getJarEntry(providerName);
                if (provider != null) {
                    InputStream is = jarFile.getInputStream(provider);
                    AnnotationServiceLocator.readServiceProvider(serviceName, is, serviceEntries);
                }
                ++n2;
            }
            return serviceEntries;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void readServiceProvider(String serviceName, InputStream servicesDeclarationFile, Set<ServiceEntry> serviceEntries) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedReader servicesReader = new BufferedReader(new InputStreamReader(servicesDeclarationFile, StandardCharsets.UTF_8));){
            servicesReader.lines().forEach(line -> {
                String[] tokens;
                int iComment = line.indexOf(35);
                if (iComment >= 0) {
                    line = line.substring(0, iComment);
                }
                if ((tokens = line.split("\\s", 2))[0].length() > 0) {
                    serviceEntries.add(new ServiceEntry(serviceName, tokens[0]));
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final class ServiceEntry {
        private final String serviceName;
        private final String serviceProviderClassName;

        public ServiceEntry(String serviceName, String serviceProviderClassName) {
            this.serviceName = serviceName;
            this.serviceProviderClassName = serviceProviderClassName;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public String getServiceProviderClassName() {
            return this.serviceProviderClassName;
        }
    }
}

