/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.llvm.ui.preferences;

import org.eclipse.cdt.managedbuilder.llvm.ui.LlvmEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.llvm.util.FindStdLibPath;
import org.eclipse.cdt.managedbuilder.llvm.util.LlvmToolOptionPathUtil;
import org.eclipse.cdt.managedbuilder.llvm.util.Separators;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class LlvmPreferenceStore {
    public static IEclipsePreferences getPreferenceStore() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.cdt.managedbuilder.llvm.ui");
        return prefs;
    }

    public static String getPreferenceStoreValue(String name) {
        return LlvmPreferenceStore.getPreferenceStore().get(name, "");
    }

    public static String getBinPath() {
        return LlvmPreferenceStore.getPreferenceStoreValue("LLVM installation folder");
    }

    public static String getIncludePath() {
        return LlvmPreferenceStore.getPreferenceStoreValue("Include path used in LLVM compilations");
    }

    public static String getLibraryPath() {
        return LlvmPreferenceStore.getPreferenceStoreValue("Library path used in LLVM builds");
    }

    public static String getLibraries() {
        return LlvmPreferenceStore.getPreferenceStoreValue("Libraries used in LLVM builds");
    }

    public static String[] getPreferenceStoreValueAsArray(String name) {
        return LlvmToolOptionPathUtil.stringToArray(name);
    }

    public static void setPreferenceStoreValue(String name, String value) {
        LlvmPreferenceStore.getPreferenceStore().put(name, value);
    }

    public static void setBinPath(String path) {
        LlvmPreferenceStore.setPreferenceStoreValue("LLVM installation folder", path);
    }

    public static void setIncludePath(String path) {
        LlvmPreferenceStore.setPreferenceStoreValue("Include path used in LLVM compilations", path);
    }

    public static void setLibraryPath(String path) {
        LlvmPreferenceStore.setPreferenceStoreValue("Library path used in LLVM builds", path);
    }

    public static void setLibrary(String lib) {
        LlvmPreferenceStore.setPreferenceStoreValue("Libraries used in LLVM builds", lib);
    }

    private static String getExistingPaths(String name) {
        String paths = "";
        if (name.equals("Include path used in LLVM compilations")) {
            paths = LlvmPreferenceStore.getIncludePath();
        } else if (name.equals("Library path used in LLVM builds")) {
            paths = LlvmPreferenceStore.getLibraryPath();
        } else if (name.equals("Libraries used in LLVM builds")) {
            paths = LlvmPreferenceStore.getLibraries();
        }
        return paths;
    }

    public static void appendValue(String name, String value) {
        String newValues;
        StringBuilder sB = new StringBuilder();
        String paths = null;
        paths = LlvmPreferenceStore.getExistingPaths(name);
        if (paths.length() != 0) {
            if (!value.equalsIgnoreCase("") && value.length() != 0 && !paths.contains(value)) {
                sB.append(paths);
                if (paths.charAt(paths.length() - 1) != Separators.getPathSeparator().charAt(0)) {
                    sB.append(Separators.getPathSeparator());
                }
                sB.append(value);
            }
        } else if (!value.equalsIgnoreCase("") && value.length() != 0) {
            sB.append(value);
        }
        if ((newValues = sB.toString()).length() != 0) {
            LlvmPreferenceStore.setPreferenceStoreValue(name, newValues);
        }
    }

    public static void appendIncludePath(String path) {
        LlvmPreferenceStore.appendValue("Include path used in LLVM compilations", path);
    }

    public static void appendLibraryPath(String path) {
        LlvmPreferenceStore.appendValue("Library path used in LLVM builds", path);
    }

    public static void appendLibrary(String lib) {
        LlvmPreferenceStore.appendValue("Libraries used in LLVM builds", lib);
    }

    public static void removeValue(String name, String value) {
        StringBuilder sB = new StringBuilder();
        String existingValues = null;
        String newValue = null;
        existingValues = LlvmPreferenceStore.getExistingPaths(name);
        if (existingValues.contains(value)) {
            if (existingValues.contains(Separators.getPathSeparator())) {
                String[] exValArray = existingValues.split(Separators.getPathSeparator());
                if (exValArray.length > 1) {
                    if ((exValArray = LlvmToolOptionPathUtil.removePathFromExistingPathList(exValArray, value)).length > 0) {
                        String[] stringArray = exValArray;
                        int n = exValArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String val = stringArray[n2];
                            sB.append(val);
                            sB.append(Separators.getPathSeparator());
                            ++n2;
                        }
                        newValue = sB.toString();
                    }
                } else {
                    newValue = "";
                }
            } else {
                newValue = "";
            }
            LlvmPreferenceStore.setPreferenceStoreValue(name, newValue);
        }
    }

    public static void removeIncludePath(String path) {
        LlvmPreferenceStore.removeValue("Include path used in LLVM compilations", path);
    }

    public static void removeLibraryPath(String path) {
        LlvmPreferenceStore.removeValue("Library path used in LLVM builds", path);
    }

    public static void removeLibrary(String lib) {
        LlvmPreferenceStore.removeValue("Libraries used in LLVM builds", lib);
    }

    public static void addMinGWStdLib() {
        String path = LlvmEnvironmentVariableSupplier.getMinGWStdLib();
        if (path != null) {
            LlvmPreferenceStore.appendLibraryPath(path);
            LlvmPreferenceStore.appendLibrary("stdc++");
        }
    }

    public static void addStdLibUnix() {
        String path = FindStdLibPath.find();
        String lib = "stdc++";
        if (path != null) {
            LlvmPreferenceStore.appendLibraryPath(path);
            LlvmPreferenceStore.appendLibrary(lib);
        }
    }
}

